package com.elitescloud.boot.auth.provider.provider.wechat;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.config.system.WechatProperties;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatAccessToken;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatUserInfo;
import com.elitescloud.boot.exception.BusinessException;
import lombok.extern.log4j.Log4j2;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

/**
 * 微信相关服务.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/20
 */
@Log4j2
public class WechatProvider {
    private final WechatTool wechatTool = WechatTool.getInstance();

    private final WechatProperties wechatProperties;

    public WechatProvider(WechatProperties wechatProperties) {
        this.wechatProperties = wechatProperties;
    }

    /**
     * 授权码获取用户信息
     *
     * @param appId
     * @param code
     * @return
     */
    public WechatUserInfo getUserInfo(@NonNull String appId, @NonNull String code) {
        // 获取微信app信息
        WechatProperties.App app = getApp(appId);
        if (app == null) {
            throw new BusinessException("未知微信应用");
        }

        // code换取access_token
        WechatAccessToken accessToken = wechatTool.oauth2AccessToken(appId, app.getSecret(), code);
        if (accessToken == null) {
            throw new BusinessException("授权或已过期，请重新操作");
        }

        // 获取用户信息
        return wechatTool.snsUserInfo(accessToken.getAccessToken(), accessToken.getOpenId());
    }

    private WechatProperties.App getApp(String appId) {
        if (CollectionUtils.isEmpty(wechatProperties.getApps())) {
            return null;
        }

        for (WechatProperties.App app : wechatProperties.getApps()) {
            if (CharSequenceUtil.equals(appId, app.getAppid())) {
                return app;
            }
        }

        return null;
    }
}
