package com.elitescloud.boot.auth.provider.provider.wechat.param;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 微信返回结果.
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
public abstract class BaseWechatResult {

    /**
     * 错误码
     */
    @JsonProperty("errcode")
    private Integer errCode;

    /**
     * 错误信息
     */
    @JsonProperty("errmsg")
    private String errMsg;

    public Integer getErrCode() {
        return errCode;
    }

    public void setErrCode(Integer errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public boolean isSuccess() {
        return errCode != null && errCode == 0;
    }
}
