package com.elitescloud.boot.auth.provider.provider.wechat.param;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 微信用户信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/20
 */
@Data
public class WechatUserInfo {

    /**
     * 用户openId
     */
    @JsonProperty(value = "openid")
    private String openid;

    /**
     * 用户昵称
     */
    @JsonProperty(value = "nickname")
    private String nickname;

    /**
     * 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
     */
    @JsonProperty(value = "sex")
    private String sex;

    /**
     * 用户个人资料填写的省份
     */
    @JsonProperty(value = "province")
    private String province;

    /**
     * 普通用户个人资料填写的城市
     */
    @JsonProperty(value = "city")
    private String city;

    /**
     * 国家，如中国为CN
     */
    @JsonProperty(value = "country")
    private String country;

    /**
     * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空。若用户更换头像，原有头像 URL 将失效。
     */
    @JsonProperty(value = "headimgurl")
    private String headimgurl;

    /**
     * 用户特权信息，json 数组，如微信沃卡用户为（chinaunicom）
     */
    @JsonProperty(value = "privilege")
    private List<String> privilege;

    /**
     * unionid
     */
    @JsonProperty(value = "unionid")
    private String unionid;
}
