package com.elitescloud.boot.auth.provider.resp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 验证码信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/08
 */
@Data
@ApiModel(value = "验证码信息")
public class CaptchaRespVO implements Serializable {
    private static final long serialVersionUID = 215247771506366950L;

    /**
     * 验证码图片，base64
     */
    @ApiModelProperty(value = "图形验证码，base64字符串", position = 1)
    private String img;

    /**
     * 验证码id
     */
    @ApiModelProperty(value = "验证码ID", position = 2)
    private String uuid;

    /**
     * 验证码内容
     */
    @JsonIgnore
    @ApiModelProperty(value = "图形验证码，base64字符串", position = 3, hidden = true)
    private String captext;
}