package com.elitescloud.boot.auth.provider.security.grant.client_user;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 客户端用户的身份认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class ClientUserAuthenticationToken extends AbstractCustomAuthenticationToken<ClientUserAuthenticationToken> {
    private static final long serialVersionUID = -2118788872828941223L;

    public ClientUserAuthenticationToken() {
        super(null, null);
    }

    public ClientUserAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public ClientUserAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.CLIENT_USER;
    }

    @NonNull
    @Override
    public ClientUserAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.valueOf(terminalParam);
        }

        ClientUserAuthenticationToken authenticationToken = new ClientUserAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(OAuth2ParameterNames.USERNAME));
        authenticationToken.setAuthenticated(false);

        return authenticationToken;
    }

}
