package com.elitescloud.boot.auth.provider.security.handler;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.security.generator.token.TokenGenerator;
import org.springframework.security.core.Authentication;

import javax.servlet.http.HttpServletRequest;

/**
 * JWT认证成功处理器.
 * <p>
 * 认证成功后返回jwt
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/1
 */
public class JwtAuthenticationSuccessHandler extends DefaultAuthenticationSuccessHandler {
    private final TokenGenerator tokenGenerator;

    public JwtAuthenticationSuccessHandler(AuthorizationProperties authorizationProperties, DelegateAuthenticationCallable authenticationCallable,
                                           TokenGenerator tokenGenerator) {
        super(authorizationProperties, authenticationCallable);
        this.tokenGenerator = tokenGenerator;
    }

    @Override
    protected Object convertResponseResult(HttpServletRequest request, Authentication authentication) {
        if (tokenGenerator == null) {
            return super.convertResponseResult(request, authentication);
        }

        return tokenGenerator.generate(authentication);
    }

    @Override
    protected String generateToken(HttpServletRequest request, Object responseResult, Authentication authentication) {
        if (responseResult instanceof OAuthToken) {
            OAuthToken authToken = (OAuthToken) responseResult;
            return authToken.getAccessToken();
        }

        return super.generateToken(request, responseResult, authentication);
    }
}
