package com.elitescloud.boot.auth.provider.security.jackson.mixin.userdetails;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.module.SimpleModule;

/**
 * 自定义jacksonModule.
 * <p>
 * 支持自定义UserDetails类的反序列化
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/07
 */
public class OAuth2AuthorizationJacksonModule extends SimpleModule {
    private static final long serialVersionUID = -6049623617656953424L;

    public OAuth2AuthorizationJacksonModule() {
        super(OAuth2AuthorizationJacksonModule.class.getName(), new Version(1, 0, 0, null, null, null));
    }

    @Override
    public void setupModule(SetupContext context) {
        context.setMixInAnnotations(GeneralUserDetails.class, MixinGeneralUserDetails.class);
        context.setMixInAnnotations(SysOrgBasicDTO.class, MixinSysOrgBasicDTO.class);
        context.setMixInAnnotations(SysTenantDTO.class, MixinSysTenantDTO.class);
        context.setMixInAnnotations(SysUserDTO.class, MixinSysUserDTO.class);
    }
}
