package com.elitescloud.boot.auth.provider.security.listener;

import lombok.extern.log4j.Log4j2;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import java.util.HashMap;
import java.util.Map;

/**
 * HttpSessionHolder监听器.
 *
 * @author Kaiser（wang shao）
 * @date 3/15/2023
 */
@Log4j2
public class HttpSessionHolder implements HttpSessionListener {

    private static final Map<String, HttpSession> SESSION_MAP = new HashMap<>();

    @Override
    public void sessionCreated(HttpSessionEvent se) {
        var session = se.getSession();
        SESSION_MAP.put(session.getId(), session);
        log.info("session创建：{}", session.getId());
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent se) {
        var sessionId = se.getSession() == null ? "" : se.getSession().getId();
        SESSION_MAP.remove(sessionId);
        log.info("session销毁：{}", sessionId);
    }

    /**
     * 获取session
     *
     * @param sessionId sessionId
     * @return session
     */
    public static HttpSession getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return SESSION_MAP.get(sessionId);
    }
}
