package com.elitescloud.boot.auth.provider.sso;

import com.elitescloud.boot.auth.sso.common.SdkSsoConstants;
import com.elitescloud.boot.auth.sso.model.UserInfoDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.constraints.NotBlank;

/**
 * sso相关接口支持.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/15
 */
@ResponseBody
@RequestMapping(value = "/oauth/sso")
@Api(tags = "SSO相关接口")
public class SsoLoginSupportController {

    private final SsoLoginSupportProvider ssoLoginSupportProvider;

    public SsoLoginSupportController(SsoLoginSupportProvider ssoLoginSupportProvider) {
        this.ssoLoginSupportProvider = ssoLoginSupportProvider;
    }

    /**
     * 生成ticket
     *
     * @param accountType 账号类型
     * @param account     账号
     * @return ticket
     */
    @GetMapping(value = "/ticket")
    @ApiOperation("生成票据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = SdkSsoConstants.PARAM_SSO_ACCOUNT_TYPE, value = "账号类型", required = true),
            @ApiImplicitParam(name = SdkSsoConstants.PARAM_SSO_ACCOUNT, value = "账号", required = true)
    })
    public ApiResult<String> generateTicket(@RequestParam(value = SdkSsoConstants.PARAM_SSO_ACCOUNT_TYPE) @NotBlank(message = "账号类型为空") String accountType,
                                            @RequestParam(value = SdkSsoConstants.PARAM_SSO_ACCOUNT) @NotBlank(message = "账号为空") String account) {
        return ssoLoginSupportProvider.generateTicket(account, accountType);
    }

    /**
     * 根据ticket获取用户信息
     *
     * @param ticket ticket
     * @return 用户信息
     */
    @GetMapping(value = "/userInfo")
    public ApiResult<UserInfoDTO> userInfo(@RequestParam(value = SdkSsoConstants.PARAM_SSO_TICKET) String ticket) {
        return ssoLoginSupportProvider.getUserInfo(ticket);
    }
}
