/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.cas.support;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.cas.model.AuthorizeDTO;
import com.elitescloud.boot.auth.cas.provider.OAuth2ClientProvider;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.boot.auth.client.config.security.resolver.impl.DefaultBearerTokenResolver;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.provider.cas.CasUserResolver;
import com.elitescloud.boot.auth.provider.cas.OidcUserResolver;
import com.elitescloud.boot.auth.provider.cas.model.AuthorizeSettingVO;
import com.elitescloud.boot.auth.provider.cas.model.OidcUser;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CasLoginSupportProvider {
    private static final Logger log = LogManager.getLogger(CasLoginSupportProvider.class);
    private final AuthorizationSdkProperties sdkProperties;
    private final OAuth2ClientProvider oAuth2ClientProvider;
    private final InternalAuthenticationGranter internalAuthenticationGranter;
    private final UserTransferHelper userTransferHelper;
    private ObjectMapper objectMapper;
    private JwtDecoder jwtDecoder;
    private OidcUserResolver oidcUserResolver;
    private CasUserResolver casUserResolver;
    private final BearerTokenResolver tokenResolver = new DefaultBearerTokenResolver();

    public CasLoginSupportProvider(AuthorizationSdkProperties sdkProperties, OAuth2ClientProvider oAuth2ClientProvider, InternalAuthenticationGranter internalAuthenticationGranter) {
        this.sdkProperties = sdkProperties;
        this.oAuth2ClientProvider = oAuth2ClientProvider;
        this.internalAuthenticationGranter = internalAuthenticationGranter;
        this.userTransferHelper = UserTransferHelper.getInstance((String)sdkProperties.getAuthServer());
    }

    public ApiResult<AuthorizeSettingVO> getSetting(HttpServletResponse response, @NotBlank String redirectUrl, String state) {
        boolean enabled = (Boolean)ObjectUtil.defaultIfNull((Object)this.sdkProperties.getCasClient().getEnabled(), (Object)false);
        AuthorizeSettingVO settingVO = new AuthorizeSettingVO();
        settingVO.setEnabled(enabled);
        if (enabled) {
            String url = this.oAuth2ClientProvider.getAuthorizeInfo(response, redirectUrl, state);
            settingVO.setAuthorizeUrl(url);
            settingVO.setAuthServer(this.sdkProperties.getAuthServer());
        }
        return ApiResult.ok((Object)settingVO);
    }

    public ApiResult<AuthorizeDTO> getAuthorizeInfo(HttpServletRequest request) {
        AuthorizeDTO dto = this.oAuth2ClientProvider.getAuthorize(request);
        return ApiResult.ok((Object)dto);
    }

    public ApiResult<OAuthToken> code2Token(HttpServletRequest request, HttpServletResponse response, @NotBlank String code) {
        if (this.oAuth2ClientProvider == null) {
            return ApiResult.fail((String)"\u672a\u542f\u7528\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1");
        }
        Result tokenResult = this.oAuth2ClientProvider.code2AccessToken(request, response, code);
        if (!tokenResult.getSuccess().booleanValue()) {
            return ApiResult.fail((String)tokenResult.getMsg());
        }
        if (tokenResult.getData() == null || !StringUtils.hasText((String)((OAuthToken)tokenResult.getData()).getIdToken())) {
            return ApiResult.fail((String)"\u8ba4\u8bc1\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u6709\u6548token");
        }
        InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = null;
        if (this.oidcUserResolver == null) {
            String sub = this.jwtDecoder.decode(((OAuthToken)tokenResult.getData()).getIdToken()).getSubject();
            authenticationToken = new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USERNAME, sub);
        } else {
            Result userResult = this.oAuth2ClientProvider.queryUserInfo(((OAuthToken)tokenResult.getData()).getTokenType(), ((OAuthToken)tokenResult.getData()).getAccessToken());
            if (!userResult.getSuccess().booleanValue()) {
                return ApiResult.fail((String)userResult.getMsg());
            }
            OidcUser oidcUser = null;
            try {
                oidcUser = (OidcUser)this.objectMapper.convertValue((Object)userResult.getData(), OidcUser.class);
            }
            catch (IllegalArgumentException e) {
                log.error("\u7528\u6237\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            authenticationToken = this.oidcUserResolver.resolve(oidcUser);
        }
        return this.grantToken(request, response, authenticationToken);
    }

    public ApiResult<OAuthToken> token2Token(HttpServletRequest request, HttpServletResponse response, String token) {
        if (CharSequenceUtil.isBlank((CharSequence)token)) {
            token = this.tokenResolver.resolve(request);
        }
        if (CharSequenceUtil.isBlank((CharSequence)token)) {
            return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u53d1\u73b0\u6709\u6548token");
        }
        String username = this.obtainUsername(token);
        InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = null;
        if (this.casUserResolver == null) {
            authenticationToken = new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USERNAME, username);
        } else {
            AuthUserDTO userInfo = this.queryUserByUsername(username);
            if (userInfo == null) {
                return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728");
            }
            Long userId = this.casUserResolver.resolve(userInfo);
            if (userId == null) {
                return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u7528\u6237\u8d26\u53f7\u5b58\u5728");
            }
            authenticationToken = new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USER_ID, userId.toString());
        }
        return this.grantToken(request, response, authenticationToken);
    }

    private ApiResult<OAuthToken> grantToken(HttpServletRequest request, HttpServletResponse response, InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken) {
        OAuthToken token = null;
        try {
            token = this.internalAuthenticationGranter.authenticate(request, response, authenticationToken);
        }
        catch (AuthenticationException e) {
            return ApiResult.fail((String)("\u8ba4\u8bc1\u5f02\u5e38\uff0c" + e.getMessage()));
        }
        return ApiResult.ok((Object)token);
    }

    private AuthUserDTO queryUserByUsername(@NotBlank String username) {
        Assert.hasText((String)username, (String)"\u7528\u6237\u8d26\u53f7\u4e3a\u7a7a");
        return (AuthUserDTO)this.userTransferHelper.getUserByUsername(username).getData();
    }

    private String obtainUsername(String token) {
        Jwt jwt = null;
        try {
            jwt = this.jwtDecoder.decode(token);
        }
        catch (Exception e) {
            throw new AuthorizationException("\u8ba4\u8bc1\u5f02\u5e38\uff0ctoken\u4e0d\u652f\u6301");
        }
        return jwt.getClaimAsString("yst_un");
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Autowired(required=false)
    public void setOidcUserResolver(OidcUserResolver oidcUserResolver) {
        this.oidcUserResolver = oidcUserResolver;
    }

    @Autowired(required=false)
    public void setCasUserResolver(CasUserResolver casUserResolver) {
        this.casUserResolver = casUserResolver;
    }

    @Autowired
    public void setJwtDecoder(JwtDecoder jwtDecoder) {
        this.jwtDecoder = jwtDecoder;
    }
}

