/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler;

import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.boot.auth.provider.security.handler.DefaultAuthenticationFailureHandler;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

public class OAuth2ServerAuthenticationFailureHandler
extends DefaultAuthenticationFailureHandler {
    private RequestCache requestCache = new HttpSessionRequestCache();
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private UniqueRequestResolver uniqueRequestResolver;

    public OAuth2ServerAuthenticationFailureHandler(AuthenticationCallable authenticationCallable, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache) {
        super(authenticationCallable);
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
    }

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String clientId = this.obtainClientId(request, response);
        request.setAttribute("cloudtClientId", (Object)clientId);
        super.onAuthenticationFailure(request, response, exception);
    }

    private String obtainClientId(HttpServletRequest request, HttpServletResponse response) {
        String[] clientIds;
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (savedRequest != null && (clientIds = savedRequest.getParameterValues("client_id")) != null && clientIds.length > 0) {
            return clientIds[0];
        }
        String reqId = this.uniqueRequestResolver.analyze(request);
        if (!StringUtils.hasText((String)reqId)) {
            return null;
        }
        OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = this.authorizationCodeRequestCache.getAuthenticationToken(reqId);
        if (codeRequest == null) {
            return null;
        }
        return codeRequest.getClientId();
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }
}

