/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler;

import com.elitescloud.boot.auth.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeRequestAuthenticationConverter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.util.StringUtils;

public class OAuth2ServerLoginUrlAuthenticationEntryPointHandler
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger log = LogManager.getLogger(OAuth2ServerLoginUrlAuthenticationEntryPointHandler.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private UniqueRequestResolver uniqueRequestResolver = null;
    private RequestCache requestCache;
    private final ThreadLocal<String> seqLocal = new ThreadLocal();

    public OAuth2ServerLoginUrlAuthenticationEntryPointHandler(String loginFormUrl, RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache) {
        super(loginFormUrl);
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        log.info("{}\u672a\u8ba4\u8bc1\uff0c\u5c06\u8f6c\u5411\u8ba4\u8bc1\u9875", (Object)request.getRequestURI());
        if (this.uniqueRequestResolver != null) {
            OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = (OAuth2AuthorizationCodeRequestAuthenticationToken)new OAuth2AuthorizationCodeRequestAuthenticationConverter().convert(request);
            String seqId = this.uniqueRequestResolver.signRequest(response);
            this.seqLocal.set(seqId);
            this.authorizationCodeRequestCache.setAuthenticationToken(seqId, codeRequest, null);
        }
        if (this.requestCache != null) {
            this.requestCache.saveRequest(request, response);
        }
        try {
            super.commence(request, response, authException);
        }
        finally {
            this.seqLocal.remove();
        }
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        Object clientLoginPage = this.obtainClientLoginPage(request);
        if (StringUtils.hasText((String)clientLoginPage)) {
            String seqId = this.seqLocal.get();
            if (StringUtils.hasText((String)seqId)) {
                clientLoginPage = (((String)clientLoginPage).contains("?") ? (String)clientLoginPage + "&" : (String)clientLoginPage + "?") + "Urq=" + seqId;
            }
            return clientLoginPage;
        }
        return super.determineUrlToUseForThisRequest(request, response, exception);
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    private String obtainClientLoginPage(HttpServletRequest request) {
        String[] clientIds = request.getParameterValues("client_id");
        if (clientIds == null || clientIds.length == 0) {
            return null;
        }
        RegisteredClient client = this.registeredClientRepository.findByClientId(clientIds[0]);
        if (client == null) {
            return null;
        }
        return (String)client.getClientSettings().getSetting("loginUrl");
    }
}

