/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.system;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import com.elitescloud.boot.auth.provider.config.system.CaptchaInfo;
import com.elitescloud.boot.auth.provider.config.system.captcha.CaptchaCodeEnum;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.io.Serializable;
import java.util.Objects;

public class LoginProperties
implements Serializable {
    private static final long serialVersionUID = 3572914221247822407L;
    private CaptchaInfo captchaInfo;
    private Boolean terminalLimit = false;
    private Boolean autoRegister = false;

    public LoginProperties() {
        this.getCaptcha();
    }

    public AbstractCaptcha getCaptchaHu() {
        if (Objects.isNull(this.captchaInfo)) {
            return null;
        }
        if (this.captchaInfo.getCodeType() == CaptchaCodeEnum.line || this.captchaInfo.getCodeType() == CaptchaCodeEnum.circle || this.captchaInfo.getCodeType() == CaptchaCodeEnum.shear) {
            switch (this.captchaInfo.getCodeType()) {
                case line: {
                    return CaptchaUtil.createLineCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                }
                case circle: {
                    return CaptchaUtil.createCircleCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
                }
            }
            return CaptchaUtil.createShearCaptcha((int)this.captchaInfo.getWidth(), (int)this.captchaInfo.getHeight());
        }
        return null;
    }

    public Captcha getCaptcha() {
        if (Objects.isNull(this.captchaInfo)) {
            this.captchaInfo = new CaptchaInfo();
            if (Objects.isNull((Object)this.captchaInfo.getCodeType())) {
                this.captchaInfo.setCodeType(CaptchaCodeEnum.arithmetic);
            }
        }
        return this.switchCaptcha(this.captchaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Captcha switchCaptcha(CaptchaInfo captchaInfo) {
        ArithmeticCaptcha captcha;
        LoginProperties loginProperties = this;
        synchronized (loginProperties) {
            switch (captchaInfo.getCodeType()) {
                case arithmetic: {
                    captcha = new ArithmeticCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case chinese: {
                    captcha = new ChineseCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case chinese_gif: {
                    captcha = new ChineseGifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case gif: {
                    captcha = new GifCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                case spec: {
                    captcha = new SpecCaptcha(captchaInfo.getWidth(), captchaInfo.getHeight());
                    captcha.setLen(captchaInfo.getLength());
                    break;
                }
                default: {
                    throw new RuntimeException("\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01\uff01\uff01\u6b63\u786e\u914d\u7f6e\u67e5\u770b " + CaptchaCodeEnum.class.getName());
                }
            }
        }
        return captcha;
    }

    public CaptchaInfo getCaptchaInfo() {
        return this.captchaInfo;
    }

    public Boolean getTerminalLimit() {
        return this.terminalLimit;
    }

    public Boolean getAutoRegister() {
        return this.autoRegister;
    }

    public void setCaptchaInfo(CaptchaInfo captchaInfo) {
        this.captchaInfo = captchaInfo;
    }

    public void setTerminalLimit(Boolean terminalLimit) {
        this.terminalLimit = terminalLimit;
    }

    public void setAutoRegister(Boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginProperties)) {
            return false;
        }
        LoginProperties other = (LoginProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$terminalLimit = this.getTerminalLimit();
        Boolean other$terminalLimit = other.getTerminalLimit();
        if (this$terminalLimit == null ? other$terminalLimit != null : !((Object)this$terminalLimit).equals(other$terminalLimit)) {
            return false;
        }
        Boolean this$autoRegister = this.getAutoRegister();
        Boolean other$autoRegister = other.getAutoRegister();
        if (this$autoRegister == null ? other$autoRegister != null : !((Object)this$autoRegister).equals(other$autoRegister)) {
            return false;
        }
        CaptchaInfo this$captchaInfo = this.getCaptchaInfo();
        CaptchaInfo other$captchaInfo = other.getCaptchaInfo();
        return !(this$captchaInfo == null ? other$captchaInfo != null : !((Object)this$captchaInfo).equals(other$captchaInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $terminalLimit = this.getTerminalLimit();
        result = result * 59 + ($terminalLimit == null ? 43 : ((Object)$terminalLimit).hashCode());
        Boolean $autoRegister = this.getAutoRegister();
        result = result * 59 + ($autoRegister == null ? 43 : ((Object)$autoRegister).hashCode());
        CaptchaInfo $captchaInfo = this.getCaptchaInfo();
        result = result * 59 + ($captchaInfo == null ? 43 : ((Object)$captchaInfo).hashCode());
        return result;
    }

    public String toString() {
        return "LoginProperties(captchaInfo=" + this.getCaptchaInfo() + ", terminalLimit=" + this.getTerminalLimit() + ", autoRegister=" + this.getAutoRegister() + ")";
    }
}

