/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.boot.auth.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class InternalAuthenticationGranter {
    private static final Logger log = LogManager.getLogger(InternalAuthenticationGranter.class);
    private final UserDetailManager userDetailManager;
    private final TokenGenerator tokenGenerator;
    private UserDetailsChecker userDetailsChecker = this::defaultAuthenticationChecker;
    private List<AuthenticationCheckService> authenticationCheckService;
    private DelegateAuthenticationCallable delegateAuthenticationCallable;

    public InternalAuthenticationGranter(UserDetailManager userDetailManager, TokenGenerator tokenGenerator) {
        this.userDetailManager = userDetailManager;
        this.tokenGenerator = tokenGenerator;
    }

    public OAuthToken authenticate(HttpServletRequest request, HttpServletResponse response, @NotNull InternalAuthenticationToken authenticationToken) {
        AuthenticationException exception = null;
        InternalAuthenticationToken authentication = null;
        OAuthToken token = null;
        try {
            authentication = this.load(authenticationToken);
            token = this.tokenGenerator.generate((Authentication)authentication);
        }
        catch (AuthenticationException e) {
            exception = e;
        }
        if (this.delegateAuthenticationCallable != null) {
            try {
                if (exception == null) {
                    this.delegateAuthenticationCallable.onLogin(request, response, token.getAccessToken(), (Authentication)authentication);
                } else {
                    this.delegateAuthenticationCallable.onLoginFailure(request, response, (Authentication)authenticationToken, exception);
                }
            }
            catch (Exception e) {
                log.info("\u8ba4\u8bc1\u56de\u8c03\u5f02\u5e38", (Throwable)e);
                if (exception == null) {
                    return token;
                }
                throw exception;
            }
        }
        return token;
    }

    private InternalAuthenticationToken load(InternalAuthenticationToken authenticationToken) {
        GeneralUserDetails userDetails = this.loadUser(authenticationToken.getIdType(), authenticationToken.getId());
        this.userDetailsChecker.check((UserDetails)userDetails);
        for (AuthenticationCheckService checkService : this.authenticationCheckService) {
            checkService.additionalAuthenticationChecks(userDetails, authenticationToken);
        }
        return new InternalAuthenticationToken(authenticationToken.getIdType(), authenticationToken.getId(), userDetails, Collections.emptyList());
    }

    @Autowired
    public void setAuthenticationCheckServiceObjectProvider(ObjectProvider<AuthenticationCheckService> authenticationCheckServiceObjectProvider) {
        this.authenticationCheckService = authenticationCheckServiceObjectProvider.stream().collect(Collectors.toList());
    }

    public void setDelegateAuthenticationCallable(DelegateAuthenticationCallable delegateAuthenticationCallable) {
        this.delegateAuthenticationCallable = delegateAuthenticationCallable;
    }

    private GeneralUserDetails loadUser(IdType idType, String id) {
        Assert.hasText((String)id, (String)"\u52a0\u8f7d\u7528\u6237\u5931\u8d25\uff0cID\u4e3a\u7a7a");
        Assert.notNull((Object)((Object)idType), (String)"\u52a0\u8f7d\u7528\u6237\u5931\u8d25\uff0cID\u7c7b\u578b\u4e3a\u7a7a");
        switch (idType) {
            case USER_ID: {
                return this.userDetailManager.loadUserById(id);
            }
            case USERNAME: {
                return this.userDetailManager.loadUserByUsername(id);
            }
            case EMAIL: {
                return this.userDetailManager.loadUserByEmail(id);
            }
            case MOBILE: {
                return this.userDetailManager.loadUserByMobile(id);
            }
        }
        throw new AuthorizationException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b");
    }

    private void defaultAuthenticationChecker(UserDetails user) {
        if (user == null) {
            throw new UsernameNotFoundException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (!user.isAccountNonLocked()) {
            log.debug("Failed to authenticate since user account is locked");
            throw new LockedException("\u8d26\u53f7\u5df2\u9501\u5b9a");
        }
        if (!user.isEnabled()) {
            log.debug("Failed to authenticate since user account is disabled");
            throw new DisabledException("\u8d26\u53f7\u5df2\u7981\u7528");
        }
        if (!user.isAccountNonExpired()) {
            log.debug("Failed to authenticate since user account has expired");
            throw new AccountExpiredException("\u8d26\u53f7\u5df2\u8fc7\u671f");
        }
    }

    public static final class InternalAuthenticationToken
    extends AbstractCustomAuthenticationToken<InternalAuthenticationToken> {
        private static final long serialVersionUID = -6577165524964905618L;
        private final IdType idType;
        private final String id;

        public LoginType loginType() {
            return LoginType.INTERNAL;
        }

        public InternalAuthenticationToken convert(HttpServletRequest request) {
            return null;
        }

        public InternalAuthenticationToken() {
            super(null, null);
            this.idType = null;
            this.id = null;
        }

        public InternalAuthenticationToken(IdType idType, String id) {
            super(null, null);
            this.idType = idType;
            this.id = id;
            super.setAuthenticated(false);
        }

        public InternalAuthenticationToken(IdType idType, String id, Object principal, Collection<GrantedAuthority> authorities) {
            super(principal, null, authorities);
            this.idType = idType;
            this.id = id;
            super.setAuthenticated(true);
        }

        public IdType getIdType() {
            return this.idType;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum IdType {
        USER_ID,
        USERNAME,
        MOBILE,
        EMAIL;

    }
}

