/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.handler;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.security.generator.token.TokenGenerator;
import com.elitescloud.boot.auth.provider.security.handler.DefaultAuthenticationSuccessHandler;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;

public class JwtAuthenticationSuccessHandler
extends DefaultAuthenticationSuccessHandler {
    private final TokenGenerator tokenGenerator;

    public JwtAuthenticationSuccessHandler(AuthorizationProperties authorizationProperties, DelegateAuthenticationCallable authenticationCallable, TokenGenerator tokenGenerator) {
        super(authorizationProperties, authenticationCallable);
        this.tokenGenerator = tokenGenerator;
    }

    @Override
    protected Object convertResponseResult(HttpServletRequest request, Authentication authentication) {
        if (this.tokenGenerator == null) {
            return super.convertResponseResult(request, authentication);
        }
        return this.tokenGenerator.generate(authentication);
    }

    @Override
    protected String generateToken(HttpServletRequest request, Object responseResult, Authentication authentication) {
        if (responseResult instanceof OAuthToken) {
            OAuthToken authToken = (OAuthToken)responseResult;
            return authToken.getAccessToken();
        }
        return super.generateToken(request, responseResult, authentication);
    }
}

