package com.elitescloud.boot.auth.provider;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.common.param.UserLoginDeviceDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 登录用户相关服务.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/20
 */
public interface AuthenticationService {

    /**
     * 尝试登录
     *
     * @param request  req
     * @param response resp
     * @return token
     */
    ApiResult<OAuthToken> attempt(HttpServletRequest request, HttpServletResponse response);

    /**
     * 注销账号
     *
     * @return 账号
     */
    ApiResult<String> logout(HttpServletRequest request, HttpServletResponse response);

    /**
     * 当前用户信息
     *
     * @return 用户信息
     */
    ApiResult<GeneralUserDetails> currentUser();

    /**
     * 获取用户的在线设备
     *
     * @param userId 账号ID
     * @return 在线设备信息
     */
    ApiResult<List<UserLoginDeviceDTO>> userOnlineDevice(Long userId);

    /**
     * 下线用户设备
     *
     * @param userId   账号ID
     * @param clientId 客户端标识
     * @return 结果
     */
    ApiResult<Boolean> expiredUserOnlineDevice(Long userId, String clientId);
}
