package com.elitescloud.boot.auth.provider.common;

import com.elitescloud.boot.auth.provider.common.param.WecomApp;

import javax.validation.constraints.NotBlank;

/**
 * 企业微信应用信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/23
 */
public interface WecomAppProvider {

    /**
     * 获取通讯录配置
     *
     * @param corpId 企业ID
     * @return 应用配置
     */
    WecomApp getContact(@NotBlank String corpId);

    /**
     * 获取应用配置
     *
     * @param corpId  企业ID
     * @param agentId 应用ID
     * @return 应用配置
     */
    WecomApp getApp(@NotBlank String corpId, @NotBlank String agentId);
}
