package com.elitescloud.boot.auth.provider.common.param;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/21 周四
 */
public enum WechatAppTypeEnum {

    /**
     * 小程序
     */
    APPLET("小程序"),
    SUBSCRIPTION("公众号"),
    SERVICE("服务号"),
    WX_WORK("企业微信"),
    ;

    /**
     * 描述
     */
    private final String description;

    WechatAppTypeEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public static WechatAppTypeEnum getByName(String name) {
        if (name == null) {
            return null;
        }

        for (WechatAppTypeEnum value : WechatAppTypeEnum.values()) {
            if (value.name().equals(name)) {
                return value;
            }
        }
        return null;
    }
}
