package com.elitescloud.boot.auth.provider.config.system;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.util.List;

/**
 * 支付宝配置.
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/5
 */
@ConfigurationProperties(prefix = "elitesland.alipay")
public class AlipayProperties implements Serializable {
    private static final long serialVersionUID = -6808472974626700690L;

    /**
     * 应用配置
     */
    private List<App> apps;

    public List<App> getApps() {
        return apps;
    }

    public void setApps(List<App> apps) {
        this.apps = apps;
    }

    public static class App implements Serializable {
        private static final long serialVersionUID = -1123328101209203479L;

        /**
         * 应用ID
         */
        private String appId;

        /**
         * AES秘钥
         */
        private String aesKey;
        /**
         * 私钥
         */
        private String privateKey;
        /**
         * 公钥
         */
        private String publicKey;
        /**
         * 支付宝公钥
         */
        private String publicKeyAlipay;

        /**
         * 是否优先使用用户ID
         */
        private boolean preferUserId = false;

        public String getAppId() {
            return appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAesKey() {
            return aesKey;
        }

        public void setAesKey(String aesKey) {
            this.aesKey = aesKey;
        }

        public String getPrivateKey() {
            return privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public String getPublicKey() {
            return publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getPublicKeyAlipay() {
            return publicKeyAlipay;
        }

        public void setPublicKeyAlipay(String publicKeyAlipay) {
            this.publicKeyAlipay = publicKeyAlipay;
        }

        public boolean isPreferUserId() {
            return preferUserId;
        }

        public void setPreferUserId(boolean preferUserId) {
            this.preferUserId = preferUserId;
        }
    }
}
