package com.elitescloud.boot.auth.provider.config.system;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 企微配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/10
 */
@ConfigurationProperties(prefix = "elitesland.wecom")
public class WecomProperties implements Serializable {

    private static final long serialVersionUID = 6248659068250008287L;

    /**
     * 配置
     */
    private List<Config> configList = new ArrayList<>(4);

    public List<Config> getConfigList() {
        return configList;
    }

    public void setConfigList(List<Config> configList) {
        this.configList = configList;
    }

    public static class Config implements Serializable {
        private static final long serialVersionUID = -8821581764160725358L;

        /**
         * 企业ID
         */
        private String corpId;

        /**
         * 通讯录的Secret
         */
        private Concat concat = new Concat();

        /**
         * 应用配置
         */
        private List<App> apps = new ArrayList<>(4);

        public String getCorpId() {
            return corpId;
        }

        public void setCorpId(String corpId) {
            this.corpId = corpId;
        }

        public Concat getConcat() {
            return concat;
        }

        public void setConcat(Concat concat) {
            this.concat = concat;
        }

        public List<App> getApps() {
            return apps;
        }

        public void setApps(List<App> apps) {
            this.apps = apps;
        }
    }

    public static class App implements Serializable {
        private static final long serialVersionUID = -8821581764160725358L;

        /**
         * 应用ID
         */
        private String agentId;

        /**
         * 应用的Secret
         */
        private String secret;

        public String getAgentId() {
            return agentId;
        }

        public void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public String getSecret() {
            return secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }
    }

    public static class Concat implements Serializable {
        private static final long serialVersionUID = -8821581764160725358L;

        /**
         * 通讯录的Secret
         */
        private String secret;

        public String getSecret() {
            return secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }
    }
}
