package com.elitescloud.boot.auth.provider.provider.alipay.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.common.AlipayAppProvider;
import com.elitescloud.boot.auth.provider.common.param.AlipayApp;
import com.elitescloud.boot.auth.provider.config.system.AlipayProperties;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/5
 */
public class DefaultAlipayAppProvider implements AlipayAppProvider {

    private final AlipayProperties alipayProperties;

    public DefaultAlipayAppProvider(AlipayProperties alipayProperties) {
        this.alipayProperties = alipayProperties;
    }

    @Override
    public AlipayApp getApp(String appId) {
        if (CollUtil.isEmpty(alipayProperties.getApps())) {
            return null;
        }

        for (var app : alipayProperties.getApps()) {
            if (CharSequenceUtil.equals(appId, app.getAppId())) {
                AlipayApp alipayApp = new AlipayApp();
                alipayApp.setAppId(app.getAppId());
                alipayApp.setAesKey(app.getAesKey());
                alipayApp.setPrivateKey(app.getPrivateKey());
                alipayApp.setPublicKey(app.getPublicKey());
                alipayApp.setPublicKeyAlipay(app.getPublicKeyAlipay());
                alipayApp.setPreferUserId(app.isPreferUserId());
                return alipayApp;
            }
        }
        return null;
    }
}
