package com.elitescloud.boot.auth.provider.provider.wecom.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.provider.common.WecomAppProvider;
import com.elitescloud.boot.auth.provider.common.param.WecomApp;
import com.elitescloud.boot.auth.provider.config.system.WecomProperties;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/23
 */
public class DefaultWecomAppProvider implements WecomAppProvider {

    private final WecomProperties wecomProperties;

    public DefaultWecomAppProvider(WecomProperties wecomProperties) {
        this.wecomProperties = wecomProperties;
    }

    @Override
    public WecomApp getContact(String corpId) {
        if (CollUtil.isEmpty(wecomProperties.getConfigList())) {
           return null;
        }

        for (WecomProperties.Config config : wecomProperties.getConfigList()) {
            if (corpId.equals(config.getCorpId())) {
                if (config.getConcat() == null) {
                    return null;
                }
                WecomApp wecomApp = new WecomApp();
                wecomApp.setCorpid(corpId);
                wecomApp.setCorpsecret(config.getConcat().getSecret());
                wecomApp.setAgentid(null);

                return wecomApp;
            }
        }
        return null;
    }

    @Override
    public WecomApp getApp(String corpId, String agentId) {
        if (CollUtil.isEmpty(wecomProperties.getConfigList())) {
            return null;
        }

        for (WecomProperties.Config config : wecomProperties.getConfigList()) {
            if (corpId.equals(config.getCorpId())) {
                if (CollUtil.isEmpty(config.getApps())) {
                    return null;
                }
                for (WecomProperties.App app : config.getApps()) {
                    WecomApp wecomApp = new WecomApp();
                    wecomApp.setCorpid(corpId);
                    wecomApp.setCorpsecret(app.getSecret());
                    wecomApp.setAgentid(app.getAgentId());
                    return wecomApp;
                }
                return null;
            }
        }
        return null;
    }
}
