package com.elitescloud.boot.auth.provider.security.grant.email_pwd;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 邮箱和密码认证.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/22
 */
public class EmailPasswordAuthenticationToken extends AbstractCustomAuthenticationToken<EmailPasswordAuthenticationToken> {
    private static final long serialVersionUID = 6652438285763663860L;

    /**
     * 验证码内容
     */
    private String captchaText;
    /**
     * 验证码key
     */
    private String captchaKey;
    /**
     * 是否必须验证码
     */
    private Boolean captchaNeeded;
    /**
     * 是否记住我
     */
    private Boolean rememberMe;

    public EmailPasswordAuthenticationToken() {
        super(null, null);
    }

    public EmailPasswordAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public EmailPasswordAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.EMAIL_PWD;
    }

    @NonNull
    @Override
    public EmailPasswordAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.valueOf(terminalParam);
        }

        String captchaNeededStr = parameters.getFirst(LoginParameterNames.CAPTCHA_NEED);
        boolean captchaNeeded = CharSequenceUtil.isBlank(captchaNeededStr) || Boolean.parseBoolean(captchaNeededStr);

        EmailPasswordAuthenticationToken authenticationToken = new EmailPasswordAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.EMAIL));
        authenticationToken.setCredentials(parameters.getFirst(OAuth2ParameterNames.PASSWORD));
        authenticationToken.setAuthenticated(false);

        authenticationToken.setCaptchaText(parameters.getFirst(LoginParameterNames.CAPTCHA_TEXT));
        authenticationToken.setCaptchaKey(parameters.getFirst(LoginParameterNames.CAPTCHA_UID));
        authenticationToken.setCaptchaNeeded(captchaNeeded);

        authenticationToken.setRememberMe(Boolean.valueOf(parameters.getFirst(LoginParameterNames.REMEMBER_ME)));

        return authenticationToken;
    }

    public String getCaptchaText() {
        return captchaText;
    }

    public void setCaptchaText(String captchaText) {
        this.captchaText = captchaText;
    }

    public String getCaptchaKey() {
        return captchaKey;
    }

    public void setCaptchaKey(String captchaKey) {
        this.captchaKey = captchaKey;
    }

    public Boolean getCaptchaNeeded() {
        return captchaNeeded;
    }

    public void setCaptchaNeeded(Boolean captchaNeeded) {
        this.captchaNeeded = captchaNeeded;
    }

    public Boolean getRememberMe() {
        return rememberMe;
    }

    public void setRememberMe(Boolean rememberMe) {
        this.rememberMe = rememberMe;
    }
}
