package com.elitescloud.boot.auth.provider.security.grant.wecom;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginAccountType;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 企业微信的身份认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2024/09/23
 */
public class WecomAuthenticationToken extends AbstractCustomAuthenticationToken<WecomAuthenticationToken> {
    private static final long serialVersionUID = 3291894847806095884L;
    private static final Logger logger = LoggerFactory.getLogger(WecomAuthenticationToken.class);

    /**
     * 企业自建应用或服务商待开发应用AgentID
     */
    private String agentId;
    /**
     * 是否记住我
     */
    private LoginAccountType accountType;

    public WecomAuthenticationToken() {
        super(null, null);
    }

    public WecomAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public WecomAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.WECOM;
    }

    @NonNull
    @Override
    public WecomAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.valueOf(terminalParam);
        }

        WecomAuthenticationToken authenticationToken = new WecomAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.WECHAT_APPID));
        authenticationToken.setCredentials(parameters.getFirst(LoginParameterNames.WECHAT_CODE));
        authenticationToken.setAuthenticated(false);

        try {
            authenticationToken.setAccountType(LoginAccountType.valueOf(parameters.getFirst(LoginParameterNames.ACCOUNT_TYPE)));
        } catch (Exception e) {
            logger.error("不支持的账号类型：{}", parameters.getFirst(LoginParameterNames.ACCOUNT_TYPE), e);
        }
        authenticationToken.setAgentId(parameters.getFirst(LoginParameterNames.WECHAT_AGENTID));

        // 账号类型
        authenticationToken.setIdentity(parameters.getFirst(LoginParameterNames.IDENTITY_TYPE));

        return authenticationToken;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public LoginAccountType getAccountType() {
        return accountType;
    }

    public void setAccountType(LoginAccountType accountType) {
        this.accountType = accountType;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
