package com.elitescloud.boot.auth.provider.sso2.common;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.common.ParamIn;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * sso属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/6 周五
 */
@Getter
@Setter
public class SsoConvertProperty implements Serializable {
    private static final long serialVersionUID = 8029817318666726320L;

    /**
     * 参数名称
     */
    private String paramName;

    /**
     * 参数位置
     */
    private ParamIn paramIn = ParamIn.QUERY;

    /**
     * 参数映射
     */
    private InternalAuthenticationGranter.IdType idType = InternalAuthenticationGranter.IdType.USERNAME;

    /**
     * 统一客户端ID
     */
    private String clientId;

    /**
     * 参数校验
     */
    public void validate() {
        Assert.notBlank(paramName, "参数名称不能为空");
        Assert.notNull(idType, "idType不能为空");
    }
}
