package com.elitescloud.boot.auth.provider.sso2.common;

import com.elitescloud.cloudt.system.vo.SysUserDTO;

import java.io.Serializable;

/**
 * 用户信息转换.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/31
 */
public interface SsoUserInfoConvert<T extends Serializable> {

    /**
     * 支持客户端
     *
     * @return 客户端标识
     */
    String supportClientId();

    /**
     * 转换用户信息
     *
     * @param userDTO 用户信息
     * @return 用户信息
     */
    T convertUser(SysUserDTO userDTO);
}
