package com.elitescloud.boot.auth.provider.sso2.controller;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.sso2.support.SsoClientSupportProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;

/**
 * 单点登录支持接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/20
 */
@ResponseBody
@RequestMapping(value = "/oauth/sso/v2", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(tags = {"单点登录"})
public class SsoClientSupportController {

    private final SsoClientSupportProvider ssoSupportProvider;

    public SsoClientSupportController(SsoClientSupportProvider ssoSupportProvider) {
        this.ssoSupportProvider = ssoSupportProvider;
    }

    @ApiOperation(value = "ticket换取token")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ticket", value = "票据", required = true),
    })
    @GetMapping(value = "/ticket2Token")
    public ApiResult<OAuthToken> ticket2Token(@NotBlank(message = "票据为空") @RequestParam(value = "ticket") String ticket,
                                              HttpServletRequest request, HttpServletResponse response) {
        return ssoSupportProvider.ticket2Token(request, response, ticket);
    }
}
