package com.elitescloud.boot.auth.provider.sso2.support.convert.properties;

import com.elitescloud.boot.auth.provider.config.properties.LdapProperties;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * sso配置-LDAP属性.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/6 周五
 */
@Getter
@Setter
public class LdapSsoConvertProperty extends SsoConvertProperty {
    private static final long serialVersionUID = 3931623131855491463L;

    /**
     * 服务端路径
     */
    private String[] urls;

    /**
     * 基本后缀
     */
    private String base;

    /**
     * 服务端账号
     */
    private String username;

    /**
     * 服务端密码
     */
    private String password;

    /**
     * 只读操作是否匿名
     */
    private Boolean anonymousReadOnly;

    /**
     * 其它LDAP设置
     */
    private final Map<String, String> baseEnvironment = new HashMap<>();

    /**
     * LdapTemplate配置
     */
    private final Template template = new Template();

    /**
     * 登录属性
     */
    private String loginAttributeName = "uid";

    /**
     * 登录的通用属性
     */
    private Map<String, Object> loginAttributes = new HashMap<>();


    public static class Template {
        /**
         * 是否忽略PartialResultException.
         */
        private boolean ignorePartialResultException = false;

        /**
         * 是否忽略NameNotFoundException.
         */
        private boolean ignoreNameNotFoundException = false;

        /**
         * 是否忽略SizeLimitExceededException异常.
         */
        private boolean ignoreSizeLimitExceededException = true;

        public boolean isIgnorePartialResultException() {
            return ignorePartialResultException;
        }

        public void setIgnorePartialResultException(boolean ignorePartialResultException) {
            this.ignorePartialResultException = ignorePartialResultException;
        }

        public boolean isIgnoreNameNotFoundException() {
            return ignoreNameNotFoundException;
        }

        public void setIgnoreNameNotFoundException(boolean ignoreNameNotFoundException) {
            this.ignoreNameNotFoundException = ignoreNameNotFoundException;
        }

        public boolean isIgnoreSizeLimitExceededException() {
            return ignoreSizeLimitExceededException;
        }

        public void setIgnoreSizeLimitExceededException(boolean ignoreSizeLimitExceededException) {
            this.ignoreSizeLimitExceededException = ignoreSizeLimitExceededException;
        }
    }
}
