/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.cas.support;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.cas.model.AuthorizeDTO;
import com.elitescloud.boot.auth.cas.model.OAuth2UserInfoDTO;
import com.elitescloud.boot.auth.cas.provider.OAuth2ClientTemplate;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.boot.auth.client.config.security.resolver.impl.DefaultBearerTokenResolver;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.cas.AuthorizeSettingCustomizer;
import com.elitescloud.boot.auth.provider.cas.CasUserResolver;
import com.elitescloud.boot.auth.provider.cas.OidcUserResolver;
import com.elitescloud.boot.auth.provider.cas.model.AuthorizeSettingVO;
import com.elitescloud.boot.auth.provider.cas.model.OidcUser;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.util.AuthCompatibilityUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.JwtUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.util.Assert;

public class CasLoginSupportProvider {
    private static final Logger log = LogManager.getLogger(CasLoginSupportProvider.class);
    private final AuthorizationProperties authorizationProperties;
    private final AuthorizationSdkProperties sdkProperties;
    private final OAuth2ClientTemplate oAuth2ClientTemplate;
    private final InternalAuthenticationGranter internalAuthenticationGranter;
    private final UserTransferHelper userTransferHelper;
    private ObjectMapper objectMapper;
    private JwtDecoder jwtDecoder;
    private OidcUserResolver oidcUserResolver;
    private CasUserResolver casUserResolver;
    private AuthorizeSettingCustomizer authorizeSettingCustomizer;
    private final BearerTokenResolver tokenResolver = new DefaultBearerTokenResolver();

    public CasLoginSupportProvider(AuthorizationProperties authorizationProperties, AuthorizationSdkProperties sdkProperties, OAuth2ClientTemplate oAuth2ClientTemplate, InternalAuthenticationGranter internalAuthenticationGranter) {
        this.authorizationProperties = authorizationProperties;
        this.sdkProperties = sdkProperties;
        this.oAuth2ClientTemplate = oAuth2ClientTemplate;
        this.internalAuthenticationGranter = internalAuthenticationGranter;
        this.userTransferHelper = UserTransferHelper.getInstance((String)sdkProperties.getAuthServer());
    }

    public ApiResult<AuthorizeSettingVO> getSetting(HttpServletRequest request, HttpServletResponse response) {
        boolean enabled = (Boolean)ObjectUtil.defaultIfNull((Object)this.sdkProperties.getCasClient().getEnabled(), (Object)false);
        AuthorizeSettingVO settingVO = new AuthorizeSettingVO();
        settingVO.setEnabled(enabled);
        if (enabled) {
            AuthorizeDTO authorizeDTO = this.oAuth2ClientTemplate.generateAuthorizeInfo(request, response);
            settingVO.setAuthorizeUrl(authorizeDTO.getUrl());
            settingVO.setAuthServer(authorizeDTO.getAuthServer());
            settingVO.setLogoutUrl(authorizeDTO.getLogoutUrl());
        }
        if (this.authorizeSettingCustomizer != null) {
            this.authorizeSettingCustomizer.customize(settingVO);
        }
        return ApiResult.ok((Object)settingVO);
    }

    public ApiResult<OAuthToken> code2Token(HttpServletRequest request, HttpServletResponse response, @NotBlank String code) {
        if (this.oAuth2ClientTemplate == null) {
            return ApiResult.fail((String)"\u672a\u542f\u7528\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1");
        }
        OAuthToken tokenResult = null;
        try {
            tokenResult = this.oAuth2ClientTemplate.code2Token(request, response, code);
        }
        catch (OAuth2AuthenticationException e) {
            throw new AuthorizationException(ApiCode.UNAUTHORIZED, "\u8ba4\u8bc1\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5", (Throwable)e);
        }
        if (tokenResult == null) {
            return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = null;
        OAuth2UserInfoDTO userResult = this.oAuth2ClientTemplate.getUserInfo(request, tokenResult.getTokenType(), tokenResult.getAccessToken());
        if (userResult == null) {
            return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (this.oidcUserResolver != null) {
            OidcUser oidcUser = null;
            try {
                oidcUser = (OidcUser)((Object)this.objectMapper.convertValue((Object)userResult, OidcUser.class));
            }
            catch (IllegalArgumentException e) {
                log.error("\u8d26\u53f7\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            authenticationToken = this.oidcUserResolver.resolve(oidcUser);
        } else {
            authenticationToken = new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USERNAME, userResult.getUsername());
        }
        Map<String, Object> jwt = this.decodeToken(tokenResult);
        String clientId = (String)jwt.get("yst_cli");
        request.setAttribute("cloudtClientId", (Object)CharSequenceUtil.blankToDefault((CharSequence)clientId, (String)this.sdkProperties.getCasClient().getOauth2Client().getClientId()));
        return this.grantToken(request, response, authenticationToken);
    }

    public ApiResult<OAuthToken> token2Token(HttpServletRequest request, HttpServletResponse response, String token) {
        if (CharSequenceUtil.isBlank((CharSequence)token)) {
            token = this.tokenResolver.resolve(request);
        }
        if (CharSequenceUtil.isBlank((CharSequence)token)) {
            return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u53d1\u73b0\u6709\u6548token");
        }
        InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = null;
        if (this.casUserResolver == null) {
            String username = this.obtainUsername(token);
            authenticationToken = new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USERNAME, username);
        } else {
            Long casUserId = this.obtainUserId(token);
            AuthUserDTO userInfo = this.queryUserById(casUserId);
            if (userInfo == null) {
                return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728");
            }
            Long userId = this.resolveUserId(userInfo);
            if (userId == null) {
                return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u7528\u6237\u8d26\u53f7\u5b58\u5728");
            }
            authenticationToken = new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USER_ID, userId.toString());
        }
        Jwt jwt = this.jwtDecoder.decode(token);
        String clientId = jwt.getClaimAsString("yst_cli");
        request.setAttribute("cloudtClientId", (Object)clientId);
        return this.grantToken(request, response, authenticationToken);
    }

    private Map<String, Object> decodeToken(OAuthToken token) {
        try {
            return JwtUtil.decode((String)CharSequenceUtil.blankToDefault((CharSequence)token.getIdToken(), (String)token.getAccessToken()));
        }
        catch (Exception e) {
            log.warn("token\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)JSONUtil.toJsonString((Object)token), (Object)e);
            return Collections.emptyMap();
        }
    }

    private Long resolveUserId(AuthUserDTO userDTO) {
        if (this.casUserResolver instanceof com.elitescloud.cloudt.authorization.api.provider.cas.CasUserResolver) {
            com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO user = AuthCompatibilityUtil.convert((AuthUserDTO)userDTO);
            return ((com.elitescloud.cloudt.authorization.api.provider.cas.CasUserResolver)this.casUserResolver).resolve(user);
        }
        return this.casUserResolver.execute(userDTO);
    }

    private ApiResult<OAuthToken> grantToken(HttpServletRequest request, HttpServletResponse response, InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken) {
        OAuthToken token = null;
        try {
            token = this.internalAuthenticationGranter.authenticate(request, response, authenticationToken);
        }
        catch (AuthenticationException e) {
            return ApiResult.fail((String)("\u8ba4\u8bc1\u5f02\u5e38\uff0c" + e.getMessage()));
        }
        return ApiResult.ok((Object)token);
    }

    private AuthUserDTO queryUserByUsername(@NotBlank String username) {
        Assert.hasText((String)username, (String)"\u7528\u6237\u8d26\u53f7\u4e3a\u7a7a");
        return (AuthUserDTO)this.userTransferHelper.getUserByUsername(username).getData();
    }

    private AuthUserDTO queryUserById(@NotNull Long id) {
        Assert.notNull((Object)id, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        return (AuthUserDTO)this.userTransferHelper.getUser(id.longValue()).getData();
    }

    private String obtainUsername(String token) {
        Jwt jwt = this.convertJwt(token);
        return jwt.getClaimAsString("yst_un");
    }

    private Long obtainUserId(String token) {
        Jwt jwt = this.convertJwt(token);
        return Long.parseLong(jwt.getClaimAsString("yst_ui"));
    }

    private Jwt convertJwt(String accessToken) {
        try {
            return this.jwtDecoder.decode(accessToken);
        }
        catch (JwtException e) {
            throw new AuthorizationException("\u8ba4\u8bc1\u5f02\u5e38\uff0ctoken\u4e0d\u652f\u6301");
        }
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Autowired(required=false)
    public void setOidcUserResolver(OidcUserResolver oidcUserResolver) {
        this.oidcUserResolver = oidcUserResolver;
    }

    @Autowired(required=false)
    public void setCasUserResolver(CasUserResolver casUserResolver) {
        this.casUserResolver = casUserResolver;
    }

    @Autowired
    public void setJwtDecoder(JwtDecoder jwtDecoder) {
        this.jwtDecoder = jwtDecoder;
    }

    @Autowired(required=false)
    public void setAuthorizeSettingCustomizer(AuthorizeSettingCustomizer authorizeSettingCustomizer) {
        this.authorizeSettingCustomizer = authorizeSettingCustomizer;
    }
}

