/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.cas.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.cas.model.AuthClientUserDTO;
import com.elitescloud.boot.auth.cas.model.UserDetailExtendDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.provider.config.properties.TokenProperties;
import com.elitescloud.boot.auth.provider.provider.DefaultTokenPropertiesProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasTokenPropertiesProvider
extends DefaultTokenPropertiesProvider {
    private static final Logger log = LoggerFactory.getLogger(CasTokenPropertiesProvider.class);
    private final AuthorizationProperties authorizationProperties;
    private final AuthorizationSdkProperties sdkProperties;
    private final UserTransferHelper userTransferHelper;

    public CasTokenPropertiesProvider(AuthorizationProperties authorizationProperties, AuthorizationSdkProperties sdkProperties) {
        super(authorizationProperties);
        this.authorizationProperties = authorizationProperties;
        this.sdkProperties = sdkProperties;
        this.userTransferHelper = UserTransferHelper.getInstance((String)sdkProperties.getAuthServer());
        log.info("CAS Client token configuration will be used");
    }

    @Override
    public TokenProperties get() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null || Boolean.FALSE.equals(this.sdkProperties.getCasClient().getEnabled())) {
            return this.defaultTokenProperties();
        }
        UserDetailExtendDTO userDetailExtendDTO = (UserDetailExtendDTO)request.getAttribute("cloudtAuthUserDetailExtend");
        if (userDetailExtendDTO != null) {
            TokenProperties tokenProperties = new TokenProperties();
            tokenProperties.setTokenTtl(userDetailExtendDTO.getTokenTtl());
            tokenProperties.setRefreshTokenTtl(userDetailExtendDTO.getRefreshTokenTtl());
            return tokenProperties;
        }
        String clientId = CharSequenceUtil.blankToDefault((CharSequence)request.getParameter("client_id"), (String)((String)request.getAttribute("cloudtClientId")));
        if (CharSequenceUtil.isBlank((CharSequence)clientId)) {
            clientId = this.sdkProperties.getCasClient().getOauth2Client().getClientId();
        }
        if (CharSequenceUtil.isBlank((CharSequence)clientId)) {
            return this.defaultTokenProperties();
        }
        Result result = this.userTransferHelper.validateClientUser(clientId, null);
        if (result.getData() == null) {
            throw new AuthorizationException(result.getMsg());
        }
        TokenProperties tokenProperties = new TokenProperties();
        tokenProperties.setTokenTtl(((AuthClientUserDTO)result.getData()).getTokenTtl());
        tokenProperties.setRefreshTokenTtl(((AuthClientUserDTO)result.getData()).getRefreshTokenTtl());
        return tokenProperties;
    }

    private TokenProperties defaultTokenProperties() {
        TokenProperties tokenProperties = new TokenProperties();
        tokenProperties.setTokenTtl(this.authorizationProperties.getTokenTtl());
        tokenProperties.setRefreshTokenTtl(this.authorizationProperties.getRefreshTokenTtl());
        return tokenProperties;
    }
}

