/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.cas.AuthorizeCacheable;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.cas.model.AuthorizeDTO;
import com.elitescloud.boot.auth.cas.model.UserDetailExtendDTO;
import com.elitescloud.boot.auth.cas.provider.OAuth2ClientTemplate;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.provider.cas.controller.CasSupportController;
import com.elitescloud.boot.auth.provider.cas.support.CasLoginSupportProvider;
import com.elitescloud.boot.auth.provider.cas.support.CasTokenPropertiesProvider;
import com.elitescloud.boot.auth.provider.security.TokenPropertiesProvider;
import com.elitescloud.boot.auth.provider.security.grant.CredentialCheckable;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Import(value={CasClientSupportConfig.class})
class CloudtCasClientConfig {
    private final AuthorizationSdkProperties sdkProperties;

    public CloudtCasClientConfig(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
    }

    @Bean
    public CasLoginSupportProvider casLoginSupportProvider(AuthorizationProperties authorizationProperties, @Autowired(required=false) OAuth2ClientTemplate oAuth2ClientTemplate, @Autowired(required=false) InternalAuthenticationGranter internalAuthenticationGranter) {
        return new CasLoginSupportProvider(authorizationProperties, this.sdkProperties, oAuth2ClientTemplate, internalAuthenticationGranter);
    }

    @Bean
    public CasSupportController oAuth2LoginSupportController(CasLoginSupportProvider supportProvider) {
        return new CasSupportController(supportProvider);
    }

    @ConditionalOnProperty(prefix="elitesland.authorization.sdk.cas-client", name={"enabled"}, havingValue="true")
    static class CasClientSupportConfig {
        private static final Logger log = LoggerFactory.getLogger(CasClientSupportConfig.class);
        private final AuthorizationSdkProperties sdkProperties;

        public CasClientSupportConfig(AuthorizationSdkProperties sdkProperties) {
            this.sdkProperties = sdkProperties;
        }

        @Bean
        public AuthenticationCallable authenticationCallableCasClient(AuthorizationSdkProperties sdkProperties) {
            final String authUrl = sdkProperties.getAuthServer();
            return new AuthenticationCallable(){

                public void onLoginFailure(HttpServletRequest request, HttpServletResponse response, @Nullable Authentication authentication, @NotNull AuthenticationException exception) {
                    log.info("\u7528\u6237\u8ba4\u8bc1\u5f02\u5e38\uff1a", (Throwable)exception);
                    if (exception instanceof UsernameNotFoundException || exception instanceof AccountStatusException) {
                        UserTransferHelper help = UserTransferHelper.getInstance((String)authUrl);
                        if (authentication instanceof InternalAuthenticationGranter.InternalAuthenticationToken) {
                            Result result;
                            InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = (InternalAuthenticationGranter.InternalAuthenticationToken)authentication;
                            Long userId = null;
                            if (authenticationToken.getIdType() == InternalAuthenticationGranter.IdType.USER_ID) {
                                userId = Long.parseLong(authenticationToken.getId());
                            } else if (authenticationToken.getIdType() == InternalAuthenticationGranter.IdType.USERNAME) {
                                AuthUserDTO user = (AuthUserDTO)help.getUserByUsername(authenticationToken.getId()).getData();
                                if (user == null) {
                                    log.error("\u81ea\u52a8\u7981\u7528\u8d26\u53f7\u5931\u8d25\uff0c\u8d26\u53f7{}\u4e0d\u5b58\u5728", (Object)authenticationToken.getId());
                                    return;
                                }
                                userId = user.getId();
                            } else if (authenticationToken.getIdType() == InternalAuthenticationGranter.IdType.MOBILE) {
                                result = help.getUserIdByMobile(List.of(authenticationToken.getId()));
                                if (result.getData() == null || ((HashMap)result.getData()).isEmpty()) {
                                    log.error("\u81ea\u52a8\u7981\u7528\u8d26\u53f7\u5931\u8d25\uff0c{}", (Object)result.getMsg());
                                    return;
                                }
                                userId = (Long)((HashMap)result.getData()).get(authenticationToken.getId());
                            } else if (authenticationToken.getIdType() == InternalAuthenticationGranter.IdType.EMAIL) {
                                result = help.getUserIdByEmail(List.of(authenticationToken.getId()));
                                if (result.getData() == null || ((HashMap)result.getData()).isEmpty()) {
                                    log.error("\u81ea\u52a8\u7981\u7528\u8d26\u53f7\u5931\u8d25\uff0c{}", (Object)result.getMsg());
                                    return;
                                }
                                userId = (Long)((HashMap)result.getData()).get(authenticationToken.getId());
                            }
                            if (userId != null) {
                                result = help.updateEnabled(userId.longValue(), false);
                                if (Boolean.FALSE.equals(result.getSuccess())) {
                                    log.error("\u81ea\u52a8\u7981\u7528\u8d26\u53f7\u5931\u8d25\uff1a" + result.getMsg());
                                }
                                return;
                            }
                            log.error("\u6682\u4e0d\u652f\u6301\u81ea\u52a8\u7981\u7528\u8d26\u53f7\uff1a" + String.valueOf((Object)authenticationToken.getIdType()));
                        }
                    }
                }
            };
        }

        @Bean
        public TokenPropertiesProvider casTokenPropertiesProvider(AuthorizationProperties authorizationProperties) {
            return new CasTokenPropertiesProvider(authorizationProperties, this.sdkProperties);
        }

        @Bean
        @ConditionalOnBean(value={RedisHelper.class})
        public AuthorizeCacheable authorizeCacheableRedis(final RedisHelper redisHelper) {
            return new AuthorizeCacheable(){
                private static final String KEY_PREFIX = "cas:authorize:";

                public void setCache(String reqId, AuthorizeDTO authorizeDTO) {
                    try {
                        redisHelper.execute(redisUtils -> redisUtils.set(KEY_PREFIX + reqId, (Object)authorizeDTO, 7L, TimeUnit.DAYS));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("\u767b\u5f55\u5f02\u5e38", e);
                    }
                }

                public AuthorizeDTO get(String reqId) {
                    try {
                        return (AuthorizeDTO)redisHelper.execute(redisUtils -> redisUtils.get(KEY_PREFIX + reqId));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("\u767b\u5f55\u5f02\u5e38", e);
                    }
                }
            };
        }

        @Bean
        public CredentialCheckable credentialCheckableCasClient() {
            return new CredentialCheckable(){
                private final UserTransferHelper userTransferHelper;
                {
                    this.userTransferHelper = UserTransferHelper.getInstance((String)sdkProperties.getAuthServer());
                }

                @Override
                public <T extends AbstractCustomAuthenticationToken<T>> boolean needCheck(T authenticationToken, GeneralUserDetails userDetails) {
                    String pwd = (String)authenticationToken.getCredentials();
                    if (CharSequenceUtil.isBlank((CharSequence)pwd)) {
                        throw new BadCredentialsException("\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
                    }
                    Long casUserId = userDetails.getUser().getCasUserId();
                    Result validateUserResult = this.userTransferHelper.validateLogin(casUserId, pwd);
                    if (!Boolean.TRUE.equals(validateUserResult.getSuccess())) {
                        throw new AuthorizationException(validateUserResult.getMsg());
                    }
                    HttpServletRequest request = HttpServletUtil.currentRequest();
                    Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u4e3a\u7a7a", (Object[])new Object[0]);
                    request.setAttribute("cloudtAuthUserDetailExtend", (Object)validateUserResult.getData());
                    if (casUserId == null) {
                        log.info("\u672a\u5411CAS\u540c\u6b65\u7684\u8d26\u53f7\uff0c\u8d70\u672c\u5730\u5bc6\u7801\u6821\u9a8c");
                        return true;
                    }
                    SysUserDTO user = userDetails.getUser();
                    if (Boolean.TRUE.equals(user.getEnabled())) {
                        user.setEnabled(Boolean.valueOf(Boolean.TRUE.equals(((UserDetailExtendDTO)validateUserResult.getData()).getEnabled())));
                    }
                    user.setLocked(Boolean.valueOf(Boolean.TRUE.equals(((UserDetailExtendDTO)validateUserResult.getData()).getLocked())));
                    user.setPwdExpiredTime(((UserDetailExtendDTO)validateUserResult.getData()).getPwdExpiredTime());
                    user.setNeedReset(((UserDetailExtendDTO)validateUserResult.getData()).getNeedReset());
                    return false;
                }
            };
        }
    }
}

