/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.provider.common.AlipayAppProvider;
import com.elitescloud.boot.auth.provider.common.WechatAppProvider;
import com.elitescloud.boot.auth.provider.common.WecomAppProvider;
import com.elitescloud.boot.auth.provider.config.properties.AuthorizationProviderProperties;
import com.elitescloud.boot.auth.provider.config.system.AlipayProperties;
import com.elitescloud.boot.auth.provider.config.system.WechatProperties;
import com.elitescloud.boot.auth.provider.config.system.WecomProperties;
import com.elitescloud.boot.auth.provider.controller.LoginSupportController;
import com.elitescloud.boot.auth.provider.provider.CaptchaProvider;
import com.elitescloud.boot.auth.provider.provider.LoginSupportProvider;
import com.elitescloud.boot.auth.provider.provider.alipay.AlipayTemplate;
import com.elitescloud.boot.auth.provider.provider.alipay.impl.DefaultAlipayAppProvider;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatTemplate;
import com.elitescloud.boot.auth.provider.provider.wechat.impl.DefaultWechatAppProvider;
import com.elitescloud.boot.auth.provider.provider.wecom.WecomTemplate;
import com.elitescloud.boot.auth.provider.provider.wecom.impl.DefaultWecomAppProvider;
import com.elitescloud.boot.core.CloudtCoreAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={CloudtCoreAutoConfiguration.class})
public class LoginSupportConfig {
    private final AuthorizationProviderProperties configProperties;

    public LoginSupportConfig(AuthorizationProviderProperties configProperties) {
        this.configProperties = configProperties;
    }

    @Bean
    public LoginSupportProvider loginSupportProvider() {
        return new LoginSupportProvider(this.configProperties);
    }

    @Bean
    public LoginSupportController commonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        return new LoginSupportController(loginSupportProvider);
    }

    @Bean
    public CaptchaProvider captchaProvider(RedisHelper redisHelper) {
        return new CaptchaProvider(redisHelper);
    }

    @Bean
    public WechatAppProvider defaultWechatAppProvider(WechatProperties wechatProperties) {
        return new DefaultWechatAppProvider(wechatProperties);
    }

    @Bean
    public WechatTemplate wechatTemplate(RedisHelper redisHelper, WechatAppProvider wechatAppProvider) {
        return new WechatTemplate(wechatAppProvider, redisHelper);
    }

    @Bean
    public WecomAppProvider defaultWecomAppProvider(WecomProperties wecomProperties) {
        return new DefaultWecomAppProvider(wecomProperties);
    }

    @Bean
    public WecomTemplate wecomTemplate(RedisHelper redisHelper, WecomAppProvider appProvider) {
        return new WecomTemplate(appProvider, redisHelper);
    }

    @Bean
    public AlipayAppProvider defaultAlipayAppProvider(AlipayProperties properties) {
        return new DefaultAlipayAppProvider(properties);
    }

    @Bean
    public AlipayTemplate alipayTemplate(AlipayAppProvider alipayAppProvider, RedisHelper redisHelper) {
        return new AlipayTemplate(alipayAppProvider, redisHelper);
    }
}

