/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.provider.config.servlet.oauth2.OAuth2AuthorizationCodeUserVerifier;
import com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer.filter.OAuth2AuthorizationCodeUserVerifierFilter;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationEndpointFilter;

public class OAuth2AuthorizationCodeUserSecurityConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<OAuth2AuthorizationCodeUserSecurityConfigurer<H>, H> {
    private final AuthorizationServerSettings authorizationServerSettings;
    private List<OAuth2AuthorizationCodeUserVerifier> userVerifiers;

    public OAuth2AuthorizationCodeUserSecurityConfigurer(AuthorizationServerSettings authorizationServerSettings) {
        this.authorizationServerSettings = authorizationServerSettings;
    }

    public void init(H http) throws Exception {
        super.init(http);
    }

    public void configure(H http) throws Exception {
        this.addUserVerifierFilter(http);
        super.configure(http);
    }

    private void addUserVerifierFilter(H http) {
        if (CollUtil.isEmpty(this.userVerifiers)) {
            return;
        }
        OAuth2AuthorizationCodeUserVerifierFilter filter = new OAuth2AuthorizationCodeUserVerifierFilter(this.authorizationServerSettings.getAuthorizationEndpoint(), this.userVerifiers);
        http.addFilterBefore((Filter)filter, OAuth2AuthorizationEndpointFilter.class);
    }

    public OAuth2AuthorizationCodeUserSecurityConfigurer<H> userVerifiers(ObjectProvider<OAuth2AuthorizationCodeUserVerifier> userVerifierObjectProvider) {
        this.userVerifiers = userVerifierObjectProvider.stream().collect(Collectors.toList());
        return this;
    }
}

