/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer.filter;

import com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer.filter.AbstractOAuth2Filter;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import java.io.IOException;
import java.security.Principal;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

public class OAuth2AuthorizationCodeStateAuthenticationFilter
extends AbstractOAuth2Filter {
    private static final Logger log = LogManager.getLogger(OAuth2AuthorizationCodeStateAuthenticationFilter.class);
    private static final OAuth2TokenType TOKEN_TYPE = new OAuth2TokenType("state");
    private final RequestMatcher oauth2AuthorizationEndpointRequestMatcher;
    private final OAuth2AuthorizationService authorizationService;
    private UniqueRequestResolver uniqueRequestResolver;

    public OAuth2AuthorizationCodeStateAuthenticationFilter(String oauth2AuthorizationEndpoint, OAuth2AuthorizationService authorizationService) {
        this.oauth2AuthorizationEndpointRequestMatcher = super.buildOAuth2AuthorizationEndpointRequestMatcher(oauth2AuthorizationEndpoint);
        this.authorizationService = authorizationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) throws ServletException, IOException {
        if (!this.oauth2AuthorizationEndpointRequestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (super.isPrincipalAuthenticated(authentication)) {
            log.info("\u8ba4\u8bc1\u8fc7\u7684\u7528\u6237\uff1a{}", (Object)authentication.getName());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String reqId = this.uniqueRequestResolver.analyze(request);
        String clientId = request.getParameter("client_id");
        if (!StringUtils.hasText((String)clientId) || !StringUtils.hasText((String)reqId)) {
            log.info("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff0c\u8ba4\u8bc1\u8bf7\u6c42\u5ffd\u7565\uff1a{}\uff0c{}", (Object)reqId, (Object)clientId);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        authentication = this.authentication(clientId, reqId);
        if (authentication != null) {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(authentication);
            SecurityContextHolder.setContext((SecurityContext)context);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }

    private Authentication authentication(String clientId, String reqId) {
        OAuth2Authorization oAuth2Authorization = this.authorizationService.findByToken(reqId, TOKEN_TYPE);
        if (oAuth2Authorization == null) {
            log.info("\u672a\u627e\u5230OAuth2Authorization\uff1a{}\uff0c\u9700\u767b\u5f55\u8ba4\u8bc1", (Object)reqId);
            return null;
        }
        if (!clientId.equals(oAuth2Authorization.getAttribute("client_id"))) {
            log.info("\u5ba2\u6237\u7aef{}, {}\u4e0d\u4e00\u81f4\uff0c\u9700\u767b\u5f55\u8ba4\u8bc1", (Object)clientId, (Object)clientId);
            return null;
        }
        Long expiresIn = (Long)oAuth2Authorization.getAttribute("expires_in");
        if (expiresIn != null && expiresIn < Instant.now().getEpochSecond()) {
            log.info("\u8ba4\u8bc1\u8bb0\u5f55{}\u5df2\u8fc7\u671f:{}", (Object)reqId, (Object)expiresIn);
            return null;
        }
        log.info("OAuth2\u5df2\u8ba4\u8bc1\uff1a{}", (Object)reqId);
        return (Authentication)oAuth2Authorization.getAttribute(Principal.class.getName());
    }
}

