/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler;

import com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler.AbstractOAuth2ServerHandler;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2AuthorizationErrorResponseHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LogManager.getLogger(OAuth2AuthorizationErrorResponseHandler.class);
    private static final Map<String, String> ERROR_DESCRIPTION = new HashMap<String, String>();

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        log.info("OAuth2\u8ba4\u8bc1\u5f02\u5e38\uff1a", (Throwable)exception);
        super.printParameters(request);
        super.printHeaders(request);
        if (exception instanceof OAuth2AuthorizationCodeRequestAuthenticationException) {
            this.sendErrorResponseForAuthorizationCodeRequest(request, response, (OAuth2AuthorizationCodeRequestAuthenticationException)exception);
            return;
        }
        if (super.supportRedirect(request)) {
            this.sendErrorResponse(request, response, exception);
            return;
        }
        this.sendErrorResponseByJson(request, response, exception);
    }

    private void sendErrorResponseForAuthorizationCodeRequest(HttpServletRequest request, HttpServletResponse response, OAuth2AuthorizationCodeRequestAuthenticationException exception) throws IOException {
        String[] descArray;
        OAuth2Error error = exception.getError();
        if (error == null) {
            this.writeResponse(response, ApiResult.fail((ApiCode)ApiCode.BAD_REQUEST, (String)("\u8ba4\u8bc1\u5931\u8d25\uff1a" + exception.getMessage())), HttpStatus.BAD_REQUEST);
            return;
        }
        String exceptionDescription = error.getDescription();
        if ("invalid_request".equals(error.getErrorCode()) && (descArray = exceptionDescription.split(":")).length == 2) {
            this.writeResponse(response, ApiResult.fail((ApiCode)ApiCode.BAD_REQUEST, (String)("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff1a" + descArray[1])), HttpStatus.BAD_REQUEST);
            return;
        }
        this.writeResponse(response, ApiResult.fail((ApiCode)ApiCode.BAD_REQUEST, (String)(ERROR_DESCRIPTION.get(error.getErrorCode()) + ":" + exceptionDescription)), HttpStatus.BAD_REQUEST);
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException = (OAuth2AuthorizationCodeRequestAuthenticationException)exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        if (authorizationCodeRequestAuthentication == null || !StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri())) {
            HttpServletUtil.writeJsonIgnoreException((HttpServletResponse)response, (Object)error);
            return;
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationCodeRequestAuthentication.getRedirectUri()).queryParam("error", new Object[]{error.getErrorCode()});
        if (StringUtils.hasText((String)error.getDescription())) {
            uriBuilder.queryParam("error_description", new Object[]{error.getDescription()});
        }
        if (StringUtils.hasText((String)error.getUri())) {
            uriBuilder.queryParam("error_uri", new Object[]{error.getUri()});
        }
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            uriBuilder.queryParam("state", new Object[]{authorizationCodeRequestAuthentication.getState()});
        }
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.toUriString());
    }

    private void sendErrorResponseByJson(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException = (OAuth2AuthorizationCodeRequestAuthenticationException)exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        if (authorizationCodeRequestAuthentication == null) {
            this.writeResponse(response, ApiResult.fail((String)"\u8bf7\u6c42\u65b9\u5f0f\u6216\u53c2\u6570\u6709\u8bef"), HttpStatus.BAD_REQUEST);
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("error", error.getErrorCode());
        if (StringUtils.hasText((String)error.getDescription())) {
            result.put("error_description", error.getDescription());
        }
        if (StringUtils.hasText((String)error.getUri())) {
            result.put("error_uri", error.getUri());
        }
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            result.put("state", authorizationCodeRequestAuthentication.getState());
        }
        this.writeResponse(response, ApiResult.fail((ApiCode)ApiCode.UNAUTHORIZED, result), HttpStatus.UNAUTHORIZED);
    }

    static {
        ERROR_DESCRIPTION.put("invalid_request", "\u8bf7\u6c42\u65b9\u5f0f\u6216\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        ERROR_DESCRIPTION.put("unauthorized_client", "\u672a\u8ba4\u8bc1\u7684\u5ba2\u6237\u7aef");
        ERROR_DESCRIPTION.put("access_denied", "\u65e0\u6743\u8bbf\u95ee");
        ERROR_DESCRIPTION.put("unsupported_response_type", "\u4e0d\u652f\u6301\u7684response_type");
        ERROR_DESCRIPTION.put("invalid_scope", "\u65e0\u6548\u7684scope");
        ERROR_DESCRIPTION.put("insufficient_scope", "\u6388\u6743\u4e0d\u8db3");
        ERROR_DESCRIPTION.put("invalid_token", "token\u65e0\u6548");
        ERROR_DESCRIPTION.put("server_error", "\u670d\u52a1\u7aef\u9519\u8bef");
        ERROR_DESCRIPTION.put("temporarily_unavailable", "\u6682\u65f6\u4e0d\u53ef\u7528");
        ERROR_DESCRIPTION.put("invalid_client", "\u5ba2\u6237\u7aef\u65e0\u6548");
        ERROR_DESCRIPTION.put("invalid_grant", "\u6388\u6743\u65e0\u6548");
        ERROR_DESCRIPTION.put("unsupported_grant_type", "\u4e0d\u652f\u6301\u7684grant_type");
        ERROR_DESCRIPTION.put("unsupported_token_type", "\u4e0d\u652f\u6301\u7684token_type");
        ERROR_DESCRIPTION.put("invalid_redirect_uri", "\u65e0\u6548\u7684redirect_uri");
    }
}

