/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.config.properties.AuthorizationProviderProperties;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.util.StringUtils;

public class CloudtTokenCustomizer
implements OAuth2TokenCustomizer<JwtEncodingContext> {
    private static final Logger logger = LoggerFactory.getLogger(CloudtTokenCustomizer.class);
    private final AuthorizationProviderProperties authorizationProviderProperties;

    public CloudtTokenCustomizer(AuthorizationProviderProperties authorizationProviderProperties) {
        this.authorizationProviderProperties = authorizationProviderProperties;
    }

    public void customize(JwtEncodingContext context) {
        Authentication authentication = context.getPrincipal();
        Object principal = authentication.getPrincipal();
        JwtClaimsSet.Builder claims = context.getClaims();
        RegisteredClient client = context.getRegisteredClient();
        if (client != null) {
            claims.claim("yst_cli", (Object)client.getClientId());
            String tenants = (String)client.getClientSettings().getSetting("tenant");
            if (StringUtils.hasText((String)tenants)) {
                claims.claim("yst_au_tt", (Object)tenants);
            }
        } else {
            String clientId = (String)HttpServletUtil.currentRequest().getAttribute("cloudtClientId");
            if (StringUtils.hasText((String)clientId)) {
                claims.claim("yst_cli", (Object)clientId);
            }
        }
        if (principal instanceof GeneralUserDetails) {
            GeneralUserDetails userDetails = (GeneralUserDetails)principal;
            claims.claim("yst_un", (Object)userDetails.getUsername());
            claims.claim("yst_ui", (Object)userDetails.getUser().getId());
            if (userDetails.getTenant() != null) {
                claims.claim("yst_ti", (Object)userDetails.getTenant().getId());
            }
            if (userDetails.getUser().getCasUserId() != null) {
                claims.claim("yst_cui", (Object)userDetails.getUser().getCasUserId());
            }
            claims.claim("yst_pt", (Object)"us");
        } else {
            claims.claim("yst_pt", (Object)"cli");
        }
        if (authentication instanceof AbstractCustomAuthenticationToken) {
            AbstractCustomAuthenticationToken cusAuth = (AbstractCustomAuthenticationToken)authentication;
            claims.claim("yst_lt", (Object)cusAuth.loginType().getType());
            claims.claim("yst_t", (Object)(cusAuth.getTerminal() == null ? "" : cusAuth.getTerminal().name()));
        }
        this.customizeForLoginForm(claims);
    }

    private void customizeForLoginForm(JwtClaimsSet.Builder claims) {
        if (CollUtil.isEmpty(this.authorizationProviderProperties.getLogin().getTokenPayloads())) {
            return;
        }
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            logger.warn("\u5f53\u524d\u8bf7\u6c42\u4e3a\u7a7a");
            return;
        }
        for (String paramName : this.authorizationProviderProperties.getLogin().getTokenPayloads()) {
            Object[] values = this.obtainParams(request, paramName);
            if (ArrayUtil.isEmpty((Object[])values)) {
                request.getAttribute(paramName);
                continue;
            }
            if ((values = (String[])Arrays.stream(values).filter(CharSequenceUtil::isNotBlank).toArray(String[]::new)).length == 0) continue;
            if (values.length == 1) {
                claims.claim(paramName, values[0]);
                continue;
            }
            claims.claim(paramName, (Object)values);
        }
    }

    private String[] obtainParams(HttpServletRequest request, String paramName) {
        Object[] values = request.getParameterValues(paramName);
        if (ArrayUtil.isNotEmpty((Object[])values)) {
            return values;
        }
        Object attribute = request.getAttribute(paramName);
        if (attribute == null) {
            return null;
        }
        if (attribute instanceof String) {
            return new String[]{(String)attribute};
        }
        if (attribute.getClass().isArray()) {
            return (String[])Arrays.stream((Object[])attribute).map(Object::toString).toArray(String[]::new);
        }
        if (attribute instanceof Collection) {
            return (String[])((Collection)attribute).stream().map(Object::toString).toArray(String[]::new);
        }
        return null;
    }
}

