/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider;

import cn.hutool.captcha.AbstractCaptcha;
import com.elitescloud.boot.auth.provider.config.properties.AuthorizationProviderProperties;
import com.elitescloud.boot.auth.provider.config.system.CaptchaEnum;
import com.elitescloud.boot.auth.provider.config.system.CaptchaInfo;
import com.elitescloud.boot.auth.provider.config.system.LoginProperties;
import com.elitescloud.boot.auth.provider.provider.CaptchaProvider;
import com.elitescloud.boot.auth.provider.resp.CaptchaRespVO;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class LoginSupportProvider {
    private static final Logger log = LogManager.getLogger(LoginSupportProvider.class);
    private final AuthorizationProviderProperties configProperties;
    private CaptchaProvider captchaManager;
    private VerifyCodeManager verifyCodeManager;

    public LoginSupportProvider(AuthorizationProviderProperties configProperties) {
        this.configProperties = configProperties;
    }

    public ApiResult<CaptchaRespVO> generateCaptcha() {
        LoginProperties loginProperties = this.configProperties.getLogin();
        CaptchaInfo captchaInfo = loginProperties.getCaptchaInfo();
        CaptchaRespVO respVO = null;
        Duration timeToLive = Duration.ofMinutes(captchaInfo.getExpiration());
        AbstractCaptcha captchaHu = loginProperties.getCaptchaHu();
        respVO = captchaHu != null ? this.getCaptchaManager().generateCaptchaHu(CaptchaEnum.LOGIN, captchaHu, timeToLive) : this.getCaptchaManager().generateCaptcha(CaptchaEnum.LOGIN, loginProperties.getCaptcha(), timeToLive);
        log.info("\u9a8c\u8bc1\u7801\uff1a{}", (Object)respVO.getCaptext());
        return ApiResult.ok((Object)respVO);
    }

    public ApiResult<Boolean> verifyCaptcha(String captchaKey, String captchaText) {
        if (!StringUtils.hasText((String)captchaKey)) {
            return ApiResult.fail((String)"\u672a\u8bbe\u7f6e\u9a8c\u8bc1\u7801");
        }
        if (!StringUtils.hasText((String)captchaText)) {
            return ApiResult.fail((String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        boolean verify = this.getCaptchaManager().verifyCaptcha(CaptchaEnum.LOGIN, captchaKey, captchaText);
        return ApiResult.ok((Object)verify);
    }

    public ApiResult<String> sendVerifyCode(SysSendVerifyCodeVO verifyCodeVO) {
        String code = this.verifyCodeManager.send("cloudt_auth_login", verifyCodeVO);
        Object msg = code == null ? "\u53d1\u9001\u6210\u529f" : "\u6a21\u62df\u53d1\u9001\u9a8c\u8bc1\u7801\uff0c\u9a8c\u8bc1\u7801\u662f" + code;
        return ApiResult.ok((Object)msg);
    }

    public CaptchaProvider getCaptchaManager() {
        if (this.captchaManager == null) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u670d\u52a1\u672a\u521d\u59cb\u5316");
        }
        return this.captchaManager;
    }

    @Autowired(required=false)
    public void setCaptchaManager(CaptchaProvider captchaManager) {
        this.captchaManager = captchaManager;
    }

    @Autowired
    public void setVerifyCodeManager(VerifyCodeManager verifyCodeManager) {
        this.verifyCodeManager = verifyCodeManager;
    }
}

