/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.user;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractUserDetailManager
implements UserDetailManager {
    private static final Logger log = LogManager.getLogger(AbstractUserDetailManager.class);
    protected final AuthorizationProperties authorizationProperties;
    protected TenantClientProvider tenantClientProvider;

    protected AbstractUserDetailManager(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    @Override
    public GeneralUserDetails loadUserByUsername(String username) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    @Override
    public GeneralUserDetails loadUserByMobile(String mobile) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    @Override
    public GeneralUserDetails registerOnLoadUserByMobileNotFound(String mobile) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u81ea\u52a8\u6ce8\u518c\u7528\u6237");
    }

    @Override
    public GeneralUserDetails loadUserByEmail(String email) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    @Override
    public GeneralUserDetails registerOnLoadUserByEmailNotFound(String email) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u81ea\u52a8\u6ce8\u518c\u7528\u6237");
    }

    @Override
    public GeneralUserDetails loadUserById(String userId) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    @Override
    public GeneralUserDetails loadUserByAccount(String account) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    @Override
    public GeneralUserDetails loadUserByWechatOpenid(String wechatOpenid) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    @Override
    public GeneralUserDetails loadUserByOpenId(String appId, String openId) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    protected GeneralUserDetails wrapUserDetails(SysUserDTO user) {
        SysTenantDTO tenant;
        String rolePrefix = this.authorizationProperties.getRolePrefix();
        if (!CollectionUtils.isEmpty((Collection)user.getRoleCodes()) && StringUtils.hasText((String)rolePrefix)) {
            Set codes = user.getRoleCodes().stream().map(t -> t.startsWith(rolePrefix) ? t : rolePrefix + t).collect(Collectors.toSet());
            user.setRoleCodes(codes);
        }
        if (user.getTenantId() == null) {
            user.setTenantId(TenantConstant.DEFAULT_TENANT_ID);
        }
        user.setRoles(Collections.unmodifiableList((List)ObjectUtil.defaultIfNull((Object)user.getRoles(), Collections.emptyList())));
        user.setRoleCodes(Collections.unmodifiableSet((Set)ObjectUtil.defaultIfNull((Object)user.getRoleCodes(), Collections.emptySet())));
        user.setRoleIds(Collections.unmodifiableSet((Set)ObjectUtil.defaultIfNull((Object)user.getRoleIds(), Collections.emptySet())));
        user.setTerminals(Collections.unmodifiableList((List)ObjectUtil.defaultIfNull((Object)user.getTerminals(), Collections.emptyList())));
        user.setOrgList(Collections.unmodifiableList((List)ObjectUtil.defaultIfNull((Object)user.getOrgList(), Collections.emptyList())));
        if (user.getSysTenantVO() == null && this.tenantClientProvider != null && this.tenantClientProvider.enabledTenant() && (tenant = this.tenantClientProvider.getCurrentTenant()) != null) {
            user.setSysTenantVO(tenant);
            user.setSysTenantDTOList(Collections.singletonList(tenant));
        }
        user.setUserTypeList(Collections.unmodifiableList((List)ObjectUtil.defaultIfNull((Object)user.getUserTypeList(), Collections.emptyList())));
        return new GeneralUserDetails(user);
    }

    @Autowired
    public void setTenantClientProvider(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }
}

