/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.wechat;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.provider.common.WechatAppProvider;
import com.elitescloud.boot.auth.provider.common.param.WechatApp;
import com.elitescloud.boot.auth.provider.common.param.WechatAppTypeEnum;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatTool;
import com.elitescloud.boot.auth.provider.provider.wechat.param.BaseWechatResult;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatAccessToken;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatCode2Session;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatOpenIdAndUnionId;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatPhoneInfo;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatToken;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatUserInfo;
import com.elitescloud.boot.exception.BusinessException;
import java.util.function.Function;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class WechatTemplate {
    private static final Logger logger = LoggerFactory.getLogger(WechatTemplate.class);
    private final WechatAppProvider wechatAppProvider;
    private final RedisHelper redisHelper;
    private final WechatTool wechatTool;

    public WechatTemplate(@NotNull WechatAppProvider wechatAppProvider, @NotNull RedisHelper redisHelper) {
        this.wechatAppProvider = wechatAppProvider;
        this.redisHelper = redisHelper;
        this.wechatTool = WechatTool.getInstance();
    }

    public WechatPhoneInfo getPhoneInfo(@NotBlank String appId, @NotBlank String code) {
        Assert.hasText((String)appId, (String)"\u5fae\u4fe1\u5e94\u7528ID\u4e3a\u7a7a");
        Assert.hasText((String)code, (String)"\u5fae\u4fe1\u6388\u6743\u7801\u4e3a\u7a7a");
        return this.executeWithToken(appId, token -> this.wechatTool.getPhoneNumber((String)token, code));
    }

    public WechatCode2Session getCode2Session(@NotBlank String appId, @NotBlank String jsCode) {
        Assert.hasText((String)appId, (String)"\u5fae\u4fe1\u5e94\u7528ID\u4e3a\u7a7a");
        Assert.hasText((String)jsCode, (String)"\u5fae\u4fe1\u6388\u6743\u7801\u4e3a\u7a7a");
        WechatApp app = this.wechatAppProvider.getApp(appId);
        if (app == null) {
            throw new BusinessException("\u672a\u77e5\u5fae\u4fe1\u5e94\u7528");
        }
        return this.wechatTool.jscode2Session(appId, app.getSecret(), jsCode);
    }

    public WechatUserInfo getUserInfo(@NonNull String appId, @NonNull String code) {
        WechatApp app = this.wechatAppProvider.getApp(appId);
        if (app == null) {
            throw new BusinessException("\u672a\u77e5\u5fae\u4fe1\u5e94\u7528");
        }
        WechatAccessToken accessToken = this.wechatTool.oauth2AccessToken(appId, app.getSecret(), code);
        if (accessToken == null) {
            throw new BusinessException("\u6388\u6743\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c");
        }
        return this.wechatTool.snsUserInfo(accessToken.getAccessToken(), accessToken.getOpenId());
    }

    public WechatOpenIdAndUnionId getOpenId(@NonNull String appId, @NotBlank String code) {
        WechatApp app = this.wechatAppProvider.getApp(appId);
        if (app == null) {
            throw new BusinessException("\u672a\u77e5\u5fae\u4fe1\u5e94\u7528");
        }
        WechatAppTypeEnum appType = (WechatAppTypeEnum)((Object)ObjUtil.defaultIfNull((Object)((Object)app.getAppType()), (Object)((Object)WechatAppTypeEnum.APPLET)));
        switch (appType) {
            case APPLET: {
                WechatCode2Session code2Session = this.getCode2Session(app.getAppid(), code);
                return new WechatOpenIdAndUnionId(code2Session.getOpenid(), code2Session.getUnionid());
            }
        }
        WechatUserInfo userInfo = this.getUserInfo(app.getAppid(), code);
        return new WechatOpenIdAndUnionId(userInfo.getOpenid(), userInfo.getUnionid());
    }

    private <T extends BaseWechatResult> T executeWithToken(@NotBlank String appId, @NotNull Function<String, T> supplier) {
        String accessToken = this.getAccessToken(appId);
        BaseWechatResult result = (BaseWechatResult)supplier.apply(accessToken);
        if (result.isSuccess()) {
            return (T)result;
        }
        this.clearAccessToken(appId);
        result = (BaseWechatResult)supplier.apply(accessToken);
        if (!result.isSuccess()) {
            logger.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)result);
        }
        return (T)result;
    }

    private String getAccessToken(String appId) {
        String key = "wechat:accesstoken:" + appId;
        String accessToken = (String)this.redisHelper.execute(redisUtils -> redisUtils.get(key));
        if (StringUtils.hasText((String)accessToken)) {
            return accessToken;
        }
        WechatApp app = this.wechatAppProvider.getApp(appId);
        Assert.notNull((Object)app, (String)(appId + "\u5fae\u4fe1\u8d26\u53f7\u4e0d\u5b58\u5728"));
        String appSecret = app.getSecret();
        Assert.hasText((String)appSecret, (String)(appId + "\u5fae\u4fe1\u8d26\u53f7\u5bc6\u7801\u4e3a\u7a7a"));
        WechatToken tokenResult = this.wechatTool.getAccessToken(appId, appSecret);
        if (tokenResult == null || CharSequenceUtil.isBlank((CharSequence)tokenResult.getAccessToken())) {
            throw new BusinessException("\u5fae\u4fe1\u6388\u6743\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.redisHelper.execute(redisUtils -> redisUtils.set(key, (Object)tokenResult.getAccessToken(), (long)(tokenResult.getExpiresIn() - 60)));
        return tokenResult.getAccessToken();
    }

    private void clearAccessToken(String appId) {
        String key = "wechat:accesstoken:" + appId;
        this.redisHelper.execute(redisUtils -> {
            redisUtils.del(new String[]{key});
            return null;
        });
    }
}

