/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.wecom;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.provider.provider.wecom.param.AccessToken;
import com.elitescloud.boot.auth.provider.provider.wecom.param.login.Code2UserInfoResult;
import com.elitescloud.boot.auth.provider.provider.wecom.param.login.OpenId2UserIdResult;
import com.elitescloud.boot.auth.provider.provider.wecom.param.login.Ticket2UserDetailResult;
import com.elitescloud.boot.auth.provider.provider.wecom.param.login.UserId2OpenIdResult;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

public class WeComTool {
    private static final Logger logger = LoggerFactory.getLogger(WeComTool.class);
    private static final RestTemplateHelper restTemplateHelper = RestTemplateHelper.instance((RestTemplate)RestTemplateFactory.instance());

    public static AccessToken getToken(@NotBlank String corpid, @NotBlank String corpsecret) {
        Assert.notBlank((CharSequence)corpid, (String)"\u4f01\u4e1aID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)corpsecret, (String)"\u5e94\u7528\u7684\u51ed\u8bc1\u79d8\u94a5\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u521b\u5efatoken\uff1a{}, {}", (Object)corpid, (Object)corpsecret);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + corpid + "&corpsecret=" + corpsecret;
        return (AccessToken)restTemplateHelper.exchangeSafely(url, HttpMethod.GET, null, (TypeReference)new TypeReference<AccessToken>(){}, new Object[0]);
    }

    public static UserId2OpenIdResult userId2OpenId(@NotBlank String accessToken, @NotBlank String userId) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)userId, (String)"\u6210\u5458ID\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("userid\u8f6copenid\uff1a{}", (Object)userId);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid?access_token=" + accessToken;
        return (UserId2OpenIdResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity(Map.of("userid", userId)), (TypeReference)new TypeReference<UserId2OpenIdResult>(){}, new Object[0]);
    }

    public static OpenId2UserIdResult openId2UserId(@NotBlank String accessToken, @NotBlank String openId) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)openId, (String)"OpenId\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("openid\u8f6cuserid\uff1a{}", (Object)openId);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_userid?access_token=" + accessToken;
        return (OpenId2UserIdResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity(Map.of("openid", openId)), (TypeReference)new TypeReference<OpenId2UserIdResult>(){}, new Object[0]);
    }

    public static Code2UserInfoResult code2UserInfo(@NotBlank String accessToken, @NotBlank String code) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)code, (String)"\u6388\u6743\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("code\u8f6c\u7528\u6237\u8eab\u4efd\uff1a{}", (Object)code);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=" + accessToken + "&code=" + code;
        return (Code2UserInfoResult)restTemplateHelper.exchangeSafely(url, HttpMethod.GET, null, (TypeReference)new TypeReference<Code2UserInfoResult>(){}, new Object[0]);
    }

    public static Ticket2UserDetailResult ticket2UserDetail(@NotBlank String accessToken, @NotBlank String ticket) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)ticket, (String)"\u7968\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("ticket\u8f6c\u7528\u6237\u8eab\u4efd\uff1a{}", (Object)ticket);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=" + accessToken;
        return (Ticket2UserDetailResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity(Map.of("user_ticket", ticket)), (TypeReference)new TypeReference<Ticket2UserDetailResult>(){}, new Object[0]);
    }
}

