/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.wecom;

import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.provider.common.WecomAppProvider;
import com.elitescloud.boot.auth.provider.common.param.WecomApp;
import com.elitescloud.boot.auth.provider.provider.wecom.WeComTool;
import com.elitescloud.boot.auth.provider.provider.wecom.param.AccessToken;
import com.elitescloud.boot.auth.provider.provider.wecom.param.BaseWecomResult;
import com.elitescloud.boot.auth.provider.provider.wecom.param.login.Code2UserInfoResult;
import com.elitescloud.boot.auth.provider.provider.wecom.param.login.Ticket2UserDetailResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import java.util.function.Function;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class WecomTemplate {
    private static final Logger logger = LoggerFactory.getLogger(WecomTemplate.class);
    private static final String INNER_APP_CONCAT = "concat";
    private final WecomAppProvider appProvider;
    private final RedisHelper redisHelper;

    public WecomTemplate(WecomAppProvider appProvider, RedisHelper redisHelper) {
        this.appProvider = appProvider;
        this.redisHelper = redisHelper;
    }

    public Code2UserInfoResult code2UserInfo(@NotBlank String corpId, @NotBlank String agentId, @NotBlank String code) {
        Assert.hasText((String)corpId, (String)"\u4f01\u4e1aID\u4e3a\u7a7a");
        Assert.hasText((String)agentId, (String)"\u5e94\u7528ID\u4e3a\u7a7a");
        Assert.hasText((String)code, (String)"\u6388\u6743\u7801\u4e3a\u7a7a");
        return this.executeWithToken(corpId, agentId, token -> WeComTool.code2UserInfo(token, code));
    }

    public Ticket2UserDetailResult getUserByTicket(@NotBlank String corpId, @NotBlank String agentId, @NotBlank String ticket) {
        Assert.hasText((String)corpId, (String)"\u4f01\u4e1aID\u4e3a\u7a7a");
        Assert.hasText((String)agentId, (String)"\u5e94\u7528ID\u4e3a\u7a7a");
        Assert.hasText((String)ticket, (String)"\u7968\u636e\u4e3a\u7a7a");
        return this.executeWithToken(corpId, agentId, token -> WeComTool.ticket2UserDetail(token, ticket));
    }

    private <T extends BaseWecomResult> T executeWithToken(@NotBlank String corpId, @NotBlank String agentId, @NotNull Function<String, T> supplier) {
        String accessToken = this.getAccessToken(corpId, agentId);
        BaseWecomResult result = (BaseWecomResult)supplier.apply(accessToken);
        if (result.isSuccess()) {
            return (T)result;
        }
        this.clearAccessToken(corpId, agentId);
        result = (BaseWecomResult)supplier.apply(accessToken);
        if (!result.isSuccess()) {
            logger.error("\u8c03\u7528\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)result);
        }
        return (T)result;
    }

    private String getAccessToken(@NotBlank String corpId, @NotBlank String agentId) {
        String key = "wecom:accesstoken:" + corpId + ":" + agentId;
        String accessToken = (String)this.redisHelper.execute(redisUtils -> redisUtils.get(key));
        if (StringUtils.hasText((String)accessToken)) {
            return accessToken;
        }
        Assert.notNull((Object)this.appProvider, (String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e");
        WecomApp app = null;
        app = INNER_APP_CONCAT.equals(agentId) ? this.appProvider.getContact(corpId) : this.appProvider.getApp(corpId, agentId);
        Assert.notNull((Object)app, (String)(agentId + "\u5e94\u7528\u672a\u914d\u7f6e"));
        String appSecret = app.getCorpsecret();
        Assert.hasText((String)appSecret, (String)("\u79d8\u94a5\u4e3a\u7a7a\uff1a" + agentId));
        AccessToken tokenResult = WeComTool.getToken(corpId, app.getCorpsecret());
        if (tokenResult == null || !tokenResult.isSuccess()) {
            logger.error("\u4f01\u4e1a\u5fae\u4fe1\u6388\u6743\u5f02\u5e38\uff1a{}, {}, {}", new Object[]{corpId, app.getCorpsecret(), JSONUtil.toJsonString((Object)tokenResult)});
            throw new BusinessException("\u4f01\u4e1a\u5fae\u4fe1\u6388\u6743\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.redisHelper.execute(redisUtils -> redisUtils.set(key, (Object)tokenResult.getAccess_token(), (long)(tokenResult.getExpires_in() - 60)));
        return tokenResult.getAccess_token();
    }

    private void clearAccessToken(String corpId, String agentId) {
        String key = "wecom:accesstoken:" + corpId + ":" + agentId;
        this.redisHelper.execute(redisUtils -> {
            redisUtils.del(new String[]{key});
            return null;
        });
    }
}

