/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.wecom.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.provider.common.WecomAppProvider;
import com.elitescloud.boot.auth.provider.common.param.WecomApp;
import com.elitescloud.boot.auth.provider.config.system.WecomProperties;
import java.util.Iterator;

public class DefaultWecomAppProvider
implements WecomAppProvider {
    private final WecomProperties wecomProperties;

    public DefaultWecomAppProvider(WecomProperties wecomProperties) {
        this.wecomProperties = wecomProperties;
    }

    @Override
    public WecomApp getContact(String corpId) {
        if (CollUtil.isEmpty(this.wecomProperties.getConfigList())) {
            return null;
        }
        for (WecomProperties.Config config : this.wecomProperties.getConfigList()) {
            if (!corpId.equals(config.getCorpId())) continue;
            if (config.getConcat() == null) {
                return null;
            }
            WecomApp wecomApp = new WecomApp();
            wecomApp.setCorpid(corpId);
            wecomApp.setCorpsecret(config.getConcat().getSecret());
            wecomApp.setAgentid(null);
            return wecomApp;
        }
        return null;
    }

    @Override
    public WecomApp getApp(String corpId, String agentId) {
        if (CollUtil.isEmpty(this.wecomProperties.getConfigList())) {
            return null;
        }
        for (WecomProperties.Config config : this.wecomProperties.getConfigList()) {
            if (!corpId.equals(config.getCorpId())) continue;
            if (CollUtil.isEmpty(config.getApps())) {
                return null;
            }
            Iterator<WecomProperties.App> iterator = config.getApps().iterator();
            if (iterator.hasNext()) {
                WecomProperties.App app = iterator.next();
                WecomApp wecomApp = new WecomApp();
                wecomApp.setCorpid(corpId);
                wecomApp.setCorpsecret(app.getSecret());
                wecomApp.setAgentid(app.getAgentId());
                return wecomApp;
            }
            return null;
        }
        return null;
    }
}

