/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.ldap;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.config.properties.LdapProperties;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.ldap.LdapAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinLdapAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.security.core.AuthenticationException;

public class LdapAuthenticationProvider
extends AbstractCustomAuthenticationProvider<LdapAuthenticationToken>
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    private LdapProperties ldapProperties;
    private LdapTemplate ldapTemplate;

    @Override
    protected GeneralUserDetails retrieveUser(LdapAuthenticationToken authentication) throws AuthenticationException {
        boolean authenticated = this.authenticateByLdap(authentication);
        if (!authenticated) {
            throw new AuthorizationException(CharSequenceUtil.blankToDefault((CharSequence)this.ldapProperties.getAuthenticatedFailMsg(), (String)"LDAP\u8ba4\u8bc1\u5931\u8d25"));
        }
        switch (this.ldapProperties.getLoginAccountType()) {
            case ID: {
                return this.userDetailManager.loadUserById((String)authentication.getPrincipal());
            }
            case USERNAME: {
                return this.userDetailManager.loadUserByUsername((String)authentication.getPrincipal());
            }
            case MOBILE: {
                return this.userDetailManager.loadUserByMobile((String)authentication.getPrincipal());
            }
            case EMAIL: {
                return this.userDetailManager.loadUserByEmail((String)authentication.getPrincipal());
            }
        }
        throw new AuthorizationException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b");
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ldapProperties == null || !this.ldapProperties.isEnabled()) {
            return;
        }
        logger.info("LDAP is enabled, the server is\uff1a{}", (Object)Arrays.toString(this.ldapProperties.getUrls()));
        this.initLdapTemplate();
    }

    @Autowired
    public void setLdapProperties(LdapProperties ldapProperties) {
        this.ldapProperties = ldapProperties;
    }

    @Override
    public Class<LdapAuthenticationToken> getAuthenticationTokenType() {
        return LdapAuthenticationToken.class;
    }

    @Override
    public Class<?> getMixinAuthenticationTokenType() {
        return MixinLdapAuthenticationToken.class;
    }

    private boolean authenticateByLdap(LdapAuthenticationToken authentication) {
        if (CharSequenceUtil.isBlank((CharSequence)((String)authentication.getPrincipal()))) {
            throw new AuthorizationException("\u8d26\u53f7\u4e3a\u7a7a");
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(8);
        if (CollUtil.isNotEmpty(this.ldapProperties.getLoginAttributes())) {
            attributes.putAll(this.ldapProperties.getLoginAttributes());
        }
        if (CollUtil.isNotEmpty(authentication.getAttributes())) {
            attributes.putAll(authentication.getAttributes());
        }
        AndFilter filter = new AndFilter().and((Filter)new EqualsFilter(this.ldapProperties.getLoginAttributeName(), (String)authentication.getPrincipal()));
        for (Map.Entry entry : attributes.entrySet()) {
            filter.and((Filter)(entry.getValue() instanceof Integer ? new EqualsFilter((String)entry.getKey(), ((Integer)entry.getValue()).intValue()) : new EqualsFilter((String)entry.getKey(), entry.getValue().toString())));
        }
        try {
            return this.ldapTemplate.authenticate(this.ldapProperties.getBase(), filter.encode(), (String)authentication.getCredentials());
        }
        catch (Exception e) {
            throw new AuthorizationException("LDAP\u8ba4\u8bc1\u5931\u8d25," + e.getMessage(), (Throwable)e);
        }
    }

    private void initLdapTemplate() {
        LdapContextSource contextSource = this.buildLdapContextSource();
        LdapProperties.Template template = this.ldapProperties.getTemplate();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        this.ldapTemplate = new LdapTemplate((ContextSource)contextSource);
        propertyMapper.from((Object)template.isIgnorePartialResultException()).to(arg_0 -> ((LdapTemplate)this.ldapTemplate).setIgnorePartialResultException(arg_0));
        propertyMapper.from((Object)template.isIgnoreNameNotFoundException()).to(arg_0 -> ((LdapTemplate)this.ldapTemplate).setIgnoreNameNotFoundException(arg_0));
        propertyMapper.from((Object)template.isIgnoreSizeLimitExceededException()).to(arg_0 -> ((LdapTemplate)this.ldapTemplate).setIgnoreSizeLimitExceededException(arg_0));
    }

    private LdapContextSource buildLdapContextSource() {
        Assert.notEmpty((Object[])this.ldapProperties.getUrls(), (String)"LDAP url\u672a\u914d\u7f6e", (Object[])new Object[0]);
        LdapContextSource source = new LdapContextSource();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from((Object)this.ldapProperties.getUsername()).to(arg_0 -> ((LdapContextSource)source).setUserDn(arg_0));
        propertyMapper.from((Object)this.ldapProperties.getPassword()).to(arg_0 -> ((LdapContextSource)source).setPassword(arg_0));
        propertyMapper.from((Object)this.ldapProperties.getAnonymousReadOnly()).to(arg_0 -> ((LdapContextSource)source).setAnonymousReadOnly(arg_0));
        propertyMapper.from((Object)this.ldapProperties.getBase()).to(arg_0 -> ((LdapContextSource)source).setBase(arg_0));
        propertyMapper.from((Object)this.ldapProperties.getUrls()).to(arg_0 -> ((LdapContextSource)source).setUrls(arg_0));
        propertyMapper.from(this.ldapProperties.getBaseEnvironment()).to(baseEnvironment -> source.setBaseEnvironmentProperties(Collections.unmodifiableMap(baseEnvironment)));
        return source;
    }
}

