/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.ldap;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class LdapAuthenticationToken
extends AbstractCustomAuthenticationToken<LdapAuthenticationToken> {
    private static final long serialVersionUID = 1932997481796678346L;
    private Map<String, Object> attributes;

    public LdapAuthenticationToken() {
        super(null, null);
    }

    public LdapAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public LdapAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    public LoginType loginType() {
        return LoginType.LDAP;
    }

    @NonNull
    public LdapAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.parse((String)terminalParam);
        }
        LdapAuthenticationToken authenticationToken = new LdapAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"username"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"password"));
        authenticationToken.setAuthenticated(false);
        authenticationToken.setIdentity((String)parameters.getFirst((Object)"identity"));
        String attrs = (String)parameters.getFirst((Object)"ldap_attrs");
        if (StringUtils.hasText((String)attrs)) {
            Map<String, Object> attrMap = Arrays.stream(attrs.split("&")).map(t -> t.split("=")).filter(t -> StringUtils.hasText((String)t[0]) && StringUtils.hasText((String)t[1])).collect(Collectors.toMap(t -> t[0], t -> t[1], (t1, t2) -> t1));
            authenticationToken.setAttributes(attrMap);
        }
        return authenticationToken;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}

