/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.wechat_phone;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatTemplate;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatPhoneInfo;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.wechat_phone.WechatPhoneAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinWechatPhoneAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class WechatPhoneAuthenticationProvider
extends AbstractCustomAuthenticationProvider<WechatPhoneAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(WechatPhoneAuthenticationProvider.class);
    @Autowired
    private WechatTemplate wechatTemplate;

    @Override
    protected GeneralUserDetails retrieveUser(WechatPhoneAuthenticationToken authentication) throws AuthenticationException {
        GeneralUserDetails user;
        String appId = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)appId)) {
            throw new AuthorizationException("\u5e94\u7528ID\u4e3a\u7a7a");
        }
        String code = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)code)) {
            throw new AuthorizationException("\u6388\u6743\u7801code\u4e3a\u7a7a");
        }
        if (authentication.isAutoRegister() && Boolean.FALSE.equals(this.configProperties.getLogin().getAutoRegister())) {
            throw new AuthorizationException("\u4e0d\u652f\u6301\u81ea\u52a8\u6ce8\u518c\u8d26\u53f7");
        }
        WechatPhoneInfo phoneInfo = this.wechatTemplate.getPhoneInfo(appId, code);
        if (phoneInfo == null) {
            throw new AuthorizationException("\u5fae\u4fe1\u6388\u6743\u83b7\u53d6\u624b\u673a\u53f7\u5f02\u5e38");
        }
        if (!phoneInfo.isSuccess() || CharSequenceUtil.isBlank((CharSequence)phoneInfo.getPhoneInfo().getPurePhoneNumber())) {
            throw new AuthorizationException(String.format("\u8c03\u7528\u5fae\u4fe1\u670d\u52a1\u5668\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25[%s,%s]", phoneInfo.getErrCode(), phoneInfo.getErrMsg()));
        }
        String mobile = phoneInfo.getPhoneInfo().getPurePhoneNumber();
        GeneralUserDetails generalUserDetails = user = authentication.isAutoRegister() ? this.userDetailManager.registerOnLoadUserByMobileNotFound(mobile) : this.userDetailManager.loadUserByMobile(mobile);
        if (user == null) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u9519\u8bef\u6216\u6388\u6743\u7801\u5df2\u8fc7\u671f");
        }
        return user;
    }

    @Override
    public Class<WechatPhoneAuthenticationToken> getAuthenticationTokenType() {
        return WechatPhoneAuthenticationToken.class;
    }

    @Override
    public Class<?> getMixinAuthenticationTokenType() {
        return MixinWechatPhoneAuthenticationToken.class;
    }
}

