/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.wechat_phone;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class WechatPhoneAuthenticationToken
extends AbstractCustomAuthenticationToken<WechatPhoneAuthenticationToken> {
    private static final long serialVersionUID = 35697051927011389L;
    private boolean autoRegister = false;

    public WechatPhoneAuthenticationToken() {
        super(null, null);
    }

    public WechatPhoneAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public WechatPhoneAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    @NonNull
    public LoginType loginType() {
        return LoginType.WX_MOBILE;
    }

    @NonNull
    public WechatPhoneAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.valueOf((String)terminalParam);
        }
        WechatPhoneAuthenticationToken authenticationToken = new WechatPhoneAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"wx_appid"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"wx_code"));
        authenticationToken.setAutoRegister("true".equalsIgnoreCase((String)parameters.getFirst((Object)"auto_register")));
        authenticationToken.setAuthenticated(false);
        authenticationToken.setIdentity((String)parameters.getFirst((Object)"identity"));
        return authenticationToken;
    }
}

