/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.provider.common.LoginDeviceLimitStrategy;
import com.elitescloud.boot.auth.provider.common.param.UserLoginDeviceDTO;
import com.elitescloud.boot.auth.provider.config.properties.AuthorizationProviderProperties;
import com.elitescloud.boot.auth.provider.config.properties.TokenProperties;
import com.elitescloud.boot.auth.provider.config.system.LoginProperties;
import com.elitescloud.boot.auth.provider.security.TokenPropertiesProvider;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;

public class CacheUserAuthenticationCallable
implements AuthenticationCallable {
    private static final Logger log = LogManager.getLogger(CacheUserAuthenticationCallable.class);
    private final AuthorizationProperties authorizationProperties;
    private final AuthorizationProviderProperties authorizationProviderProperties;
    private final AuthenticationCache authenticationCache;
    private final TokenPropertiesProvider tokenPropertiesProvider;

    public CacheUserAuthenticationCallable(AuthorizationProperties authorizationProperties, AuthorizationProviderProperties authorizationProviderProperties, AuthenticationCache authenticationCache, TokenPropertiesProvider tokenPropertiesProvider) {
        this.authorizationProperties = authorizationProperties;
        this.authorizationProviderProperties = authorizationProviderProperties;
        this.authenticationCache = authenticationCache;
        this.tokenPropertiesProvider = tokenPropertiesProvider;
    }

    public void onLogin(HttpServletRequest request, HttpServletResponse response, String token, Authentication authentication) throws IOException, ServletException {
        GeneralUserDetails user = null;
        if (authentication.getPrincipal() instanceof GeneralUserDetails) {
            user = (GeneralUserDetails)authentication.getPrincipal();
        }
        if (user != null && StringUtils.hasText((String)token)) {
            log.info("\u7528\u6237{}\u767b\u5f55\uff0ctoken\uff1a{}", (Object)user.getUsername(), (Object)token);
            this.authenticationCache.setUserDetail(token, user, this.cachePrincipalDuration());
            UserLoginDeviceDTO loginDevice = this.buildLoginDevice(request, user, token);
            List<UserLoginDeviceDTO> deviceList = this.queryUserDeviceOnline(user);
            deviceList = this.expireOtherDevice(deviceList, loginDevice.getClientId());
            deviceList = new ArrayList<UserLoginDeviceDTO>(deviceList);
            deviceList.add(loginDevice);
            this.authenticationCache.setAttribute(user.getUserId().toString() + ":loginDevice", deviceList, null);
        }
    }

    public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
        if (!StringUtils.hasText((String)token)) {
            return;
        }
        if (principal instanceof GeneralUserDetails) {
            log.info("\u7528\u6237{}\u6ce8\u9500", (Object)((GeneralUserDetails)principal).getUsername());
            CompletableFuture.runAsync(() -> this.clearUserDevice((GeneralUserDetails)principal, token)).whenComplete((res, exp) -> {
                if (exp != null) {
                    log.error("\u6e05\u7406\u7528\u6237\u5728\u7ebf\u8bbe\u5907\u5f02\u5e38\uff1a", exp);
                }
            });
        }
        this.authenticationCache.removeUserDetail(token);
    }

    private void clearUserDevice(GeneralUserDetails user, String token) {
        List deviceList = (List)this.authenticationCache.getAttribute(user.getUserId().toString() + ":loginDevice");
        if (CollUtil.isEmpty((Collection)deviceList)) {
            return;
        }
        ArrayList<UserLoginDeviceDTO> finalDeviceList = new ArrayList<UserLoginDeviceDTO>(deviceList.size());
        for (UserLoginDeviceDTO userLoginDeviceDTO : deviceList) {
            if (token.equals(userLoginDeviceDTO.getToken())) continue;
            finalDeviceList.add(userLoginDeviceDTO);
        }
        this.authenticationCache.setAttribute(user.getUserId().toString() + ":loginDevice", finalDeviceList, null);
    }

    private List<UserLoginDeviceDTO> queryUserDeviceOnline(GeneralUserDetails user) {
        List deviceList = (List)this.authenticationCache.getAttribute(user.getUserId().toString() + ":loginDevice");
        if (CollUtil.isEmpty((Collection)deviceList)) {
            return Collections.emptyList();
        }
        return deviceList.stream().filter(t -> this.authenticationCache.exists(t.getToken())).collect(Collectors.toList());
    }

    private List<UserLoginDeviceDTO> expireOtherDevice(List<UserLoginDeviceDTO> currentDeviceList, String clientId) {
        if (CollUtil.isEmpty(currentDeviceList) || CharSequenceUtil.isBlank((CharSequence)clientId)) {
            return currentDeviceList;
        }
        LoginDeviceLimitStrategy strategy = null;
        for (LoginProperties.LoginDeviceLimiter l : this.authorizationProviderProperties.getLogin().getLoginDeviceLimiters()) {
            if (!clientId.equals(l.getClientId())) continue;
            strategy = l.getStrategy();
            break;
        }
        if (LoginDeviceLimitStrategy.INVALID_OTHER != strategy) {
            return currentDeviceList;
        }
        ArrayList<UserLoginDeviceDTO> finalDeviceList = new ArrayList<UserLoginDeviceDTO>(currentDeviceList.size());
        for (UserLoginDeviceDTO userLoginDeviceDTO : currentDeviceList) {
            if (clientId.equals(userLoginDeviceDTO.getClientId())) {
                this.authenticationCache.removeUserDetail(userLoginDeviceDTO.getToken());
                log.info("\u81ea\u52a8\u6ce8\u9500\u5df2\u767b\u5f55\u7684\u8bbe\u5907\uff1a{}, {}, {}", (Object)userLoginDeviceDTO.getLoginTime(), (Object)userLoginDeviceDTO.getUserAgent(), (Object)userLoginDeviceDTO.getToken());
                continue;
            }
            finalDeviceList.add(userLoginDeviceDTO);
        }
        return finalDeviceList;
    }

    private UserLoginDeviceDTO buildLoginDevice(HttpServletRequest request, GeneralUserDetails user, String token) {
        UserLoginDeviceDTO loginDevice = new UserLoginDeviceDTO();
        if (request != null) {
            String clientId = (String)request.getAttribute("cloudtClientId");
            loginDevice.setClientId(clientId);
            loginDevice.setLoginIp(HttpServletUtil.currentClientIp());
            loginDevice.setUserAgent(request.getHeader("User-Agent"));
        }
        loginDevice.setToken(token);
        loginDevice.setLoginTime(DatetimeUtil.toStr((LocalDateTime)LocalDateTime.now()));
        return loginDevice;
    }

    private Duration cachePrincipalDuration() {
        TokenProperties tokenProperties = this.tokenPropertiesProvider.get();
        if (tokenProperties != null) {
            return tokenProperties.getTokenTtl();
        }
        if (this.authorizationProperties.getTokenTtl() != null && this.authorizationProperties.getTokenTtl().getSeconds() > 0L) {
            return this.authorizationProperties.getTokenTtl();
        }
        return null;
    }
}

