/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginDeviceLimitStrategy;
import com.elitescloud.boot.auth.provider.common.param.UserLoginDeviceDTO;
import com.elitescloud.boot.auth.provider.config.properties.AuthorizationProviderProperties;
import com.elitescloud.boot.auth.provider.config.system.LoginProperties;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysUserType;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;

public class DefaultAuthenticationCheckServiceImpl<T extends AbstractCustomAuthenticationToken<T>>
implements AuthenticationCheckService<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthenticationCheckServiceImpl.class);
    private final AuthorizationProviderProperties configProperties;
    private final AuthenticationCache authenticationCache;

    public DefaultAuthenticationCheckServiceImpl(AuthorizationProviderProperties configProperties, AuthenticationCache authenticationCache) {
        this.configProperties = configProperties;
        this.authenticationCache = authenticationCache;
    }

    @Override
    public void additionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) throws AuthenticationException {
        this.validateUserType(userDetails);
        this.validateTerminal(userDetails, authentication);
        this.validateDevice(userDetails, authentication);
    }

    private void validateUserType(GeneralUserDetails userDetails) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return;
        }
        String userType = request.getParameter("user_type");
        logger.info("loginLimit-userType\uff1a{}", (Object)userType);
        if (StrUtil.isBlank((CharSequence)userType)) {
            return;
        }
        if (CollUtil.isNotEmpty((Collection)userDetails.getUser().getUserTypeList())) {
            for (SysUserType sysUserType : userDetails.getUser().getUserTypeList()) {
                if (!userType.equals(sysUserType.getUserType())) continue;
                return;
            }
        }
        throw new AuthorizationException("\u65e0\u6743\u9650\u767b\u5f55");
    }

    private void validateDevice(GeneralUserDetails userDetails, T authentication) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return;
        }
        List<LoginProperties.LoginDeviceLimiter> limiters = this.configProperties.getLogin().getLoginDeviceLimiters();
        if (CollUtil.isEmpty(limiters)) {
            return;
        }
        String clientId = (String)request.getAttribute("cloudtClientId");
        if (CharSequenceUtil.isBlank((CharSequence)clientId)) {
            return;
        }
        LoginProperties.LoginDeviceLimiter limiter = null;
        for (LoginProperties.LoginDeviceLimiter l : limiters) {
            if (!clientId.equals(l.getClientId())) continue;
            limiter = l;
            break;
        }
        if (limiter == null || LoginDeviceLimitStrategy.NO_LIMIT == limiter.getStrategy()) {
            return;
        }
        if (LoginDeviceLimitStrategy.ONE_LIMIT == limiter.getStrategy()) {
            List deviceList = (List)this.authenticationCache.getAttribute(userDetails.getUserId().toString() + ":loginDevice");
            if (CollUtil.isEmpty((Collection)deviceList)) {
                return;
            }
            for (UserLoginDeviceDTO userLoginDeviceDTO : deviceList) {
                if (!clientId.equals(userLoginDeviceDTO.getClientId()) || !this.authenticationCache.exists(userLoginDeviceDTO.getToken())) continue;
                throw new AuthorizationException(CharSequenceUtil.blankToDefault((CharSequence)limiter.getOneLimitTip(), (String)"\u60a8\u5df2\u5728\u5176\u5b83\u8bbe\u5907\u767b\u5f55"));
            }
        }
    }

    private void validateTerminal(GeneralUserDetails userDetails, T authentication) {
        Boolean terminalEnabled = this.configProperties.getLogin().getTerminalLimit();
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)terminalEnabled, (Object)false)).booleanValue()) {
            return;
        }
        Terminal terminal = authentication.getTerminal();
        if (terminal == null) {
            throw new AuthorizationException("\u672a\u8bbe\u7f6e\u767b\u5f55\u7ec8\u7aef");
        }
        List terminals = userDetails.getUser().getTerminals();
        if (terminals == null || terminals.isEmpty()) {
            throw new AuthorizationException("\u65e0\u6743\u9650\u767b\u5f55\u8be5\u7ec8\u7aef");
        }
        if (!terminals.contains(terminal)) {
            throw new AuthorizationException("\u65e0\u6743\u9650\u767b\u5f55\u8be5\u7ec8\u7aef");
        }
    }
}

