/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.impl;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.config.system.TenantProperties;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TenantAuthenticationCheckServiceImpl<T extends AbstractCustomAuthenticationToken<T>>
implements AuthenticationCheckService<T> {
    private static final Logger log = LogManager.getLogger(TenantAuthenticationCheckServiceImpl.class);
    private final TenantProperties tenantProperties;
    private final TenantClientProvider tenantClientProvider;

    public TenantAuthenticationCheckServiceImpl(TenantProperties tenantProperties, TenantClientProvider tenantClientProvider) {
        this.tenantProperties = tenantProperties;
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public void additionalAuthenticationChecks(GeneralUserDetails user, T authentication) throws AuthenticationException {
        boolean limitLogin = Boolean.TRUE.equals(this.tenantProperties.isLimitTenantLogin());
        if (!this.tenantClientProvider.enabledTenant() || !limitLogin) {
            return;
        }
        if (user.isOperation()) {
            return;
        }
        SysTenantDTO requestTenant = this.tenantClientProvider.obtainTenantFromRequest();
        if (requestTenant != null) {
            if (user.getTenant() != null && user.getTenant().getId().longValue() == requestTenant.getId().longValue()) {
                return;
            }
            throw new AuthorizationException("\u8bf7\u8f6c\u81f3\u5bf9\u5e94\u79df\u6237\u4e0b\u7684\u7ad9\u70b9\u767b\u5f55");
        }
        if (!this.tenantClientProvider.isDefaultDomainRequest()) {
            throw new AuthorizationException("\u672a\u77e5\u5f53\u524d\u7ad9\u70b9\u6240\u5c5e\u79df\u6237");
        }
        this.printDomain();
        if (Terminal.BACKEND.equals((Object)authentication.getTerminal())) {
            throw new AuthorizationException("\u8bf7\u8f6c\u81f3\u5bf9\u5e94\u79df\u6237\u4e0b\u7684\u7ad9\u70b9\u767b\u5f55");
        }
    }

    private void printDomain() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        String uri = request.getRequestURL().toString();
        String domain = HttpServletUtil.obtainDomain((HttpServletRequest)request);
        log.info("\u8bf7\u6c42\u8def\u5f84\uff1a{}, {}", (Object)uri, (Object)domain);
    }
}

