/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.listener;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.util.ObjUtil;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

public class HttpSessionHolder
implements HttpSessionListener {
    private static final Logger log = LogManager.getLogger(HttpSessionHolder.class);
    private static final Map<String, HttpSession> SESSION_MAP = new HashMap<String, HttpSession>();

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        SESSION_MAP.put(session.getId(), session);
        log.info("session\u521b\u5efa\uff1a{}\uff0c\u6709\u6548\u65f6\u95f4\uff1a{}", (Object)session.getId(), ObjUtil.defaultIfNull((Object)HttpSessionHolder.getSessionTimeOutSeconds(session.getId()), (Object)session.getMaxInactiveInterval()));
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        String sessionId = se.getSession() == null ? "" : se.getSession().getId();
        SESSION_MAP.remove(sessionId);
        log.info("session\u9500\u6bc1\uff1a{}", (Object)sessionId);
    }

    public static HttpSession getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return SESSION_MAP.get(sessionId);
    }

    private static Long getSessionTimeOutSeconds(String sessionId) {
        SessionRepository sessionRepository = (SessionRepository)SpringContextHolder.getBean(SessionRepository.class);
        if (sessionRepository == null) {
            return null;
        }
        Session session = sessionRepository.findById(sessionId);
        Duration maxInactiveInterval = session == null ? null : session.getMaxInactiveInterval();
        return maxInactiveInterval == null ? null : Long.valueOf(maxInactiveInterval.toSeconds());
    }
}

